/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ResourceHistoryRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ResourceHistoryConfTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class ResourceHistoryConfDirectoryPanel
extends DirectoryPanel<ResourceHistoryConfTO, ResourceHistoryConfTO, RHConfProvider, ResourceHistoryRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 7636531280703026376L;
    protected final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private final String entityKey;

    public ResourceHistoryConfDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, String entityKey, PageReference pageRef) {
        super("first", pageRef, false, false);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.restClient = new ResourceHistoryRestClient();
        this.setShowResultPage(false);
        this.disableCheckBoxes();
        this.entityKey = entityKey;
        this.initResultTable();
    }

    @Override
    protected List<IColumn<ResourceHistoryConfTO, String>> getColumns() {
        ArrayList<IColumn<ResourceHistoryConfTO, String>> columns = new ArrayList<IColumn<ResourceHistoryConfTO, String>>();
        columns.add((IColumn<ResourceHistoryConfTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<ResourceHistoryConfTO, String>)new PropertyColumn((IModel)new StringResourceModel("creator", (Component)this), (Object)"creator", "creator"));
        columns.add((IColumn<ResourceHistoryConfTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("creation", (Component)this), "creation", "creation"));
        return columns;
    }

    @Override
    public ActionsPanel<ResourceHistoryConfTO> getActions(IModel<ResourceHistoryConfTO> model) {
        ActionsPanel<ResourceHistoryConfTO> panel = super.getActions(model);
        final ResourceHistoryConfTO resHistoryConfTO = (ResourceHistoryConfTO)model.getObject();
        panel.add(new ActionLink<ResourceHistoryConfTO>(){
            private static final long serialVersionUID = -3369924994540304232L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceHistoryConfTO modelObject) {
                ResourceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                ResourceHistoryConfDirectoryPanel.this.viewConfiguration(modelObject, target);
                target.add(new Component[]{ResourceHistoryConfDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW, "RESOURCE_HISTORY_LIST");
        panel.add(new ActionLink<ResourceHistoryConfTO>(){
            private static final long serialVersionUID = -3369924994540304232L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceHistoryConfTO modelObject) {
                try {
                    ((ResourceHistoryRestClient)ResourceHistoryConfDirectoryPanel.this.restClient).restore(modelObject.getKey());
                    ResourceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                    target.add(new Component[]{ResourceHistoryConfDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While restoring {}", (Object)resHistoryConfTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ResourceHistoryConfDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.RESTORE, "RESOURCE_HISTORY_RESTORE");
        panel.add(new ActionLink<ResourceHistoryConfTO>(){
            private static final long serialVersionUID = -3369924994540304232L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceHistoryConfTO modelObject) {
                try {
                    ((ResourceHistoryRestClient)ResourceHistoryConfDirectoryPanel.this.restClient).delete(modelObject.getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)ResourceHistoryConfDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ResourceHistoryConfDirectoryPanel.this.container});
                    ResourceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)resHistoryConfTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ResourceHistoryConfDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "RESOURCE_HISTORY_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected String paginatorRowsKey() {
        return "resourcehistoryconf.paginator.rows";
    }

    protected abstract void viewConfiguration(ResourceHistoryConfTO var1, AjaxRequestTarget var2);

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<ResourceHistoryConfTO, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected RHConfProvider dataProvider() {
        return new RHConfProvider(this.rows);
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class RHConfProvider
    extends DirectoryDataProvider<ResourceHistoryConfTO> {
        private static final long serialVersionUID = -5244315453787001412L;
        private final SortableDataProviderComparator<ResourceHistoryConfTO> comparator;

        public RHConfProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("creation", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ResourceHistoryConfTO>(this);
        }

        public Iterator<ResourceHistoryConfTO> iterator(long first, long count) {
            List<ResourceHistoryConfTO> configurations = ((ResourceHistoryRestClient)ResourceHistoryConfDirectoryPanel.this.restClient).list(ResourceHistoryConfDirectoryPanel.this.entityKey);
            Collections.sort(configurations, this.comparator);
            return configurations.iterator();
        }

        public long size() {
            return ((ResourceHistoryRestClient)ResourceHistoryConfDirectoryPanel.this.restClient).list(ResourceHistoryConfDirectoryPanel.this.entityKey).size();
        }

        public IModel<ResourceHistoryConfTO> model(ResourceHistoryConfTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

