/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.FormLayoutInfoUtils;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ExecMessageModal;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RemediationRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyObjectWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.GroupWizardBuilder;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class RemediationDirectoryPanel
extends DirectoryPanel<RemediationTO, RemediationTO, RemediationProvider, RemediationRestClient> {
    private static final long serialVersionUID = 8525204188127106587L;

    public RemediationDirectoryPanel(String id, PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.restClient = new RemediationRestClient();
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"REMEDIATION_REMEDY");
    }

    @Override
    protected List<IColumn<RemediationTO, String>> getColumns() {
        ArrayList<IColumn<RemediationTO, String>> columns = new ArrayList<IColumn<RemediationTO, String>>();
        columns.add((IColumn<RemediationTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("operation"), (Object)"operation", "operation"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("anyType"), (Object)"anyType", "anyType"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("remoteName"), (Object)"remoteName", "remoteName"));
        columns.add((IColumn<RemediationTO, String>)new PropertyColumn((IModel)new ResourceModel("resource"), (Object)"resource", "resource"));
        columns.add((IColumn<RemediationTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel("instant"), "instant", "instant"));
        return columns;
    }

    @Override
    protected ActionsPanel<RemediationTO> getActions(final IModel<RemediationTO> model) {
        ActionsPanel<RemediationTO> panel = super.getActions(model);
        panel.add(new ActionLink<RemediationTO>(){
            private static final long serialVersionUID = 6193210574968203299L;

            @Override
            public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                RemediationDirectoryPanel.this.modal.header((IModel)new ResourceModel("error"));
                RemediationDirectoryPanel.this.modal.setContent(new ExecMessageModal(((RemediationTO)model.getObject()).getError()));
                RemediationDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{RemediationDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW_DETAILS, "REMEDIATION_READ");
        if (((RemediationTO)model.getObject()).getOperation() == ResourceOperation.DELETE) {
            String entitlements = StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_DELETE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_DELETE" : AnyEntitlement.DELETE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",");
            panel.add(new ActionLink<RemediationTO>(){
                private static final long serialVersionUID = 6193210574968203299L;

                @Override
                public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                    try {
                        ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(((RemediationTO)model.getObject()).getKey(), ((RemediationTO)model.getObject()).getKeyPayload());
                        SyncopeConsoleSession.get().info((Serializable)((Object)RemediationDirectoryPanel.this.getString("operation_succeeded")));
                        target.add(new Component[]{RemediationDirectoryPanel.this.container});
                    }
                    catch (SyncopeClientException e) {
                        DirectoryPanel.LOG.error("While performing remediation {}", (Object)((RemediationTO)model.getObject()).getKey(), (Object)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    }
                    ((BasePage)RemediationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }, ActionLink.ActionType.CLOSE, entitlements, true);
        } else {
            String entitlements = ((RemediationTO)model.getObject()).getOperation() == ResourceOperation.CREATE ? StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_CREATE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_CREATE" : AnyEntitlement.CREATE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",") : StringUtils.join((Object[])new String[]{"REMEDIATION_REMEDY", AnyTypeKind.USER.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "USER_UPDATE" : (AnyTypeKind.GROUP.name().equals(((RemediationTO)model.getObject()).getAnyType()) ? "GROUP_UPDATE" : AnyEntitlement.UPDATE.getFor(((RemediationTO)model.getObject()).getAnyType()))}, (String)",");
            panel.add(new ActionLink<RemediationTO>(){
                private static final long serialVersionUID = 6193210574968203299L;

                @Override
                public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                    RemediationDirectoryPanel.this.modal.setFormModel(new CompoundPropertyModel(model.getObject()));
                    RemediationTO remediationTO = (RemediationTO)model.getObject();
                    switch (remediationTO.getAnyType()) {
                        case "USER": {
                            UserTO previousUserTO;
                            UserTO newUserTO;
                            if (remediationTO.getAnyPatchPayload() == null) {
                                newUserTO = (UserTO)remediationTO.getAnyTOPayload();
                                previousUserTO = null;
                            } else {
                                previousUserTO = (UserTO)new UserRestClient().read(remediationTO.getAnyPatchPayload().getKey());
                                newUserTO = AnyOperations.patch((UserTO)previousUserTO, (UserPatch)((UserPatch)remediationTO.getAnyPatchPayload()));
                            }
                            AjaxWizard.EditItemActionEvent<UserTO> userEvent = new AjaxWizard.EditItemActionEvent<UserTO>(newUserTO, target);
                            userEvent.forceModalPanel(new RemediationUserWizardBuilder((RemediationTO)model.getObject(), previousUserTO, newUserTO, new AnyTypeRestClient().read(remediationTO.getAnyType()).getClasses(), (UserFormLayoutInfo)FormLayoutInfoUtils.fetch(Arrays.asList(remediationTO.getAnyType())).getLeft(), RemediationDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            RemediationDirectoryPanel.this.send((IEventSink)RemediationDirectoryPanel.this, Broadcast.EXACT, userEvent);
                            break;
                        }
                        case "GROUP": {
                            GroupTO previousGroupTO;
                            GroupTO newGroupTO;
                            if (remediationTO.getAnyPatchPayload() == null) {
                                newGroupTO = (GroupTO)remediationTO.getAnyTOPayload();
                                previousGroupTO = null;
                            } else {
                                previousGroupTO = (GroupTO)new GroupRestClient().read(remediationTO.getAnyPatchPayload().getKey());
                                newGroupTO = AnyOperations.patch((GroupTO)previousGroupTO, (GroupPatch)((GroupPatch)remediationTO.getAnyPatchPayload()));
                            }
                            AjaxWizard.EditItemActionEvent<GroupTO> groupEvent = new AjaxWizard.EditItemActionEvent<GroupTO>(newGroupTO, target);
                            groupEvent.forceModalPanel(new RemediationGroupWizardBuilder((RemediationTO)model.getObject(), previousGroupTO, newGroupTO, new AnyTypeRestClient().read(remediationTO.getAnyType()).getClasses(), (GroupFormLayoutInfo)FormLayoutInfoUtils.fetch(Arrays.asList(remediationTO.getAnyType())).getMiddle(), RemediationDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            RemediationDirectoryPanel.this.send((IEventSink)RemediationDirectoryPanel.this, Broadcast.EXACT, groupEvent);
                            break;
                        }
                        default: {
                            AnyObjectTO previousAnyObjectTO;
                            AnyObjectTO newAnyObjectTO;
                            if (remediationTO.getAnyPatchPayload() == null) {
                                newAnyObjectTO = (AnyObjectTO)remediationTO.getAnyTOPayload();
                                previousAnyObjectTO = null;
                            } else {
                                previousAnyObjectTO = (AnyObjectTO)new AnyObjectRestClient().read(remediationTO.getAnyPatchPayload().getKey());
                                newAnyObjectTO = AnyOperations.patch((AnyObjectTO)previousAnyObjectTO, (AnyObjectPatch)((AnyObjectPatch)remediationTO.getAnyPatchPayload()));
                            }
                            AjaxWizard.EditItemActionEvent<AnyObjectTO> anyObjectEvent = new AjaxWizard.EditItemActionEvent<AnyObjectTO>(newAnyObjectTO, target);
                            anyObjectEvent.forceModalPanel(new RemediationAnyObjectWizardBuilder((RemediationTO)model.getObject(), previousAnyObjectTO, newAnyObjectTO, new AnyTypeRestClient().read(remediationTO.getAnyType()).getClasses(), (AnyObjectFormLayoutInfo)((Map)FormLayoutInfoUtils.fetch(Arrays.asList(remediationTO.getAnyType())).getRight()).values().iterator().next(), RemediationDirectoryPanel.this.pageRef).build("content", AjaxWizard.Mode.EDIT));
                            RemediationDirectoryPanel.this.send((IEventSink)RemediationDirectoryPanel.this, Broadcast.EXACT, anyObjectEvent);
                        }
                    }
                }
            }, ActionLink.ActionType.EDIT, entitlements);
        }
        panel.add(new ActionLink<RemediationTO>(){
            private static final long serialVersionUID = 6193210574968203299L;

            @Override
            public void onClick(AjaxRequestTarget target, RemediationTO ignore) {
                try {
                    ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).delete(((RemediationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)RemediationDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{RemediationDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((RemediationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)RemediationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "REMEDIATION_DELETE", true);
        return panel;
    }

    @Override
    protected RemediationProvider dataProvider() {
        return new RemediationProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "remediation.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    private class RemediationAnyObjectWizardBuilder
    extends AnyObjectWizardBuilder {
        private static final long serialVersionUID = 6993139499479015083L;
        private final AnyObjectTO previousAnyObjectTO;
        private final RemediationTO remediationTO;

        RemediationAnyObjectWizardBuilder(RemediationTO remediationTO, AnyObjectTO previousAnyObjectTO, AnyObjectTO anyObjectTO, List<String> anyTypeClasses, AnyObjectFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousAnyObjectTO, anyObjectTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.previousAnyObjectTO = previousAnyObjectTO;
            this.remediationTO = remediationTO;
        }

        @Override
        protected Serializable onApplyInternal(AnyWrapper<AnyObjectTO> modelObject) {
            ProvisioningResult result;
            AnyObjectTO inner = modelObject.getInnerObject();
            if (this.remediationTO.getAnyPatchPayload() == null) {
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), inner);
            } else {
                AnyObjectPatch patch = AnyOperations.diff((AnyObjectTO)inner, (AnyObjectTO)this.previousAnyObjectTO, (boolean)false);
                if (patch.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyPatch)patch);
                }
            }
            return result;
        }
    }

    private class RemediationGroupWizardBuilder
    extends GroupWizardBuilder {
        private static final long serialVersionUID = -5233791906979150786L;
        private final GroupTO previousGroupTO;
        private final RemediationTO remediationTO;

        RemediationGroupWizardBuilder(RemediationTO remediationTO, GroupTO previousGroupTO, GroupTO groupTO, List<String> anyTypeClasses, GroupFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousGroupTO, groupTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.previousGroupTO = previousGroupTO;
            this.remediationTO = remediationTO;
        }

        @Override
        protected Serializable onApplyInternal(AnyWrapper<GroupTO> modelObject) {
            ProvisioningResult result;
            GroupTO inner = modelObject.getInnerObject();
            if (this.remediationTO.getAnyPatchPayload() == null) {
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), inner);
            } else {
                GroupPatch patch = AnyOperations.diff((GroupTO)inner, (GroupTO)this.previousGroupTO, (boolean)false);
                if (patch.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyPatch)patch);
                }
            }
            return result;
        }
    }

    private class RemediationUserWizardBuilder
    extends UserWizardBuilder {
        private static final long serialVersionUID = 6840699724316612700L;
        private final UserTO previousUserTO;
        private final RemediationTO remediationTO;

        RemediationUserWizardBuilder(RemediationTO remediationTO, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageRef) {
            super(previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageRef);
            this.previousUserTO = previousUserTO;
            this.remediationTO = remediationTO;
        }

        @Override
        protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
            ProvisioningResult result;
            UserTO inner = modelObject.getInnerObject();
            if (this.remediationTO.getAnyPatchPayload() == null) {
                result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), inner);
            } else {
                UserPatch patch = AnyOperations.diff((UserTO)inner, (UserTO)this.previousUserTO, (boolean)false);
                if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                    PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                    patch.setPassword(passwordPatch);
                }
                if (patch.isEmpty()) {
                    result = new ProvisioningResult();
                    result.setEntity((EntityTO)inner);
                } else {
                    result = ((RemediationRestClient)RemediationDirectoryPanel.this.restClient).remedy(this.remediationTO.getKey(), (AnyPatch)patch);
                }
            }
            return result;
        }
    }

    public static class RemediationProvider
    extends DirectoryDataProvider<RemediationTO> {
        private static final long serialVersionUID = -2311716167583335852L;
        private final RemediationRestClient restClient = new RemediationRestClient();

        public RemediationProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("instant", SortOrder.ASCENDING);
        }

        public Iterator<RemediationTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return this.restClient.getRemediations((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return this.restClient.countRemediations();
        }

        public IModel<RemediationTO> model(final RemediationTO remediation) {
            return new IModel<RemediationTO>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public RemediationTO getObject() {
                    return remediation;
                }
            };
        }
    }
}

