/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormChoiceComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListViewPanel<T extends Serializable>
extends WizardMgtPanel<T> {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final Logger LOG = LoggerFactory.getLogger(ListViewPanel.class);
    private ActionLinksTogglePanel<T> togglePanel;
    private final CheckGroupSelector groupSelector;
    private final Model<CheckAvailability> check;
    private final ListView<T> beans;
    private final List<T> listOfItems;

    private ListViewPanel(String id, List<T> list, Class<T> reference, List<String> includes, final ActionsPanel<T> actions, CheckAvailability check, boolean reuseItem, boolean wizardInModal, IModel<? extends Collection<T>> model) {
        super(id, wizardInModal);
        List<Object> toBeIncluded;
        this.setOutputMarkupId(true);
        this.togglePanel = this.getTogglePanel();
        this.check = Model.of((Serializable)((Object)check));
        this.addInnerObject(new Component[]{new Label("caption", (IModel)new ResourceModel("listview.caption", ""))});
        final CheckGroup checkGroup = new CheckGroup("group", model);
        checkGroup.setOutputMarkupId(true);
        checkGroup.add(new Behavior[]{new IndicatorAjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.addInnerObject(new Component[]{checkGroup});
        this.groupSelector = new CheckGroupSelector("groupselector", checkGroup);
        this.addInnerObject(this.groupSelector.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).setVisible(this.check.getObject() == CheckAvailability.AVAILABLE).setEnabled(this.check.getObject() == CheckAvailability.AVAILABLE));
        if (includes == null || includes.isEmpty()) {
            toBeIncluded = new ArrayList();
            for (Field field2 : reference.getDeclaredFields()) {
                toBeIncluded.add(field2.getName());
            }
        } else {
            toBeIncluded = includes;
        }
        if (toBeIncluded.isEmpty()) {
            LOG.warn("No field has been retrieved from {}", (Object)reference.getName());
            this.listOfItems = new ArrayList<T>();
        } else if (list == null || list.isEmpty()) {
            LOG.info("No item to be shown");
            this.listOfItems = new ArrayList<T>();
        } else {
            this.listOfItems = list;
            if (LOG.isDebugEnabled()) {
                toBeIncluded.forEach(field -> LOG.debug("Show field {}", field));
            }
        }
        this.addInnerObject(new Component[]{this.header(toBeIncluded)});
        this.beans = new ListView<T>("beans", this.listOfItems){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> beanItem) {
                beanItem.add(new Component[]{new Check("check", beanItem.getModel(), checkGroup).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).setVisible(ListViewPanel.this.check.getObject() == CheckAvailability.AVAILABLE || ListViewPanel.this.check.getObject() == CheckAvailability.DISABLED).setEnabled(ListViewPanel.this.check.getObject() == CheckAvailability.AVAILABLE)});
                final Serializable bean = (Serializable)beanItem.getModelObject();
                ListView<String> fields = new ListView<String>("fields", toBeIncluded){
                    private static final long serialVersionUID = 1L;

                    protected void populateItem(ListItem<String> fieldItem) {
                        fieldItem.add(new Component[]{ListViewPanel.this.getValueComponent((String)fieldItem.getModelObject(), bean)});
                        if (ListViewPanel.this.togglePanel != null) {
                            fieldItem.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"cursor: pointer;"))});
                            fieldItem.add(new Behavior[]{new AjaxEventBehavior("click"){
                                private static final long serialVersionUID = -9027652037484739586L;

                                protected String findIndicatorId() {
                                    return "";
                                }

                                protected void onEvent(AjaxRequestTarget target) {
                                    ListViewPanel.this.togglePanel.toggleWithContent(target, actions.cloneWithLabels("actions", new Model(bean)), bean);
                                }
                            }});
                        }
                    }
                };
                beanItem.add(new Component[]{fields});
                if (ListViewPanel.this.togglePanel == null) {
                    beanItem.add(new Component[]{actions.clone("actions", new Model(bean))});
                } else {
                    beanItem.add(new Component[]{new ActionsPanel("actions", new Model(bean)).setVisible(false).setEnabled(false)});
                }
            }
        };
        this.beans.setOutputMarkupId(true);
        this.beans.setReuseItems(reuseItem);
        this.beans.setRenderBodyOnly(true);
        checkGroup.add(new Component[]{this.beans});
    }

    private ListView<String> header(List<String> labels) {
        return new ListView<String>("names", labels){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Label("name", (IModel)new ResourceModel((String)item.getModelObject(), (String)item.getModelObject()))});
            }
        };
    }

    public void setCheckAvailability(CheckAvailability check) {
        this.check.setObject((Serializable)((Object)check));
        Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
        if (target.isPresent()) {
            ((AjaxRequestTarget)target.get()).add(this.groupSelector.setVisible(check == CheckAvailability.AVAILABLE), this.groupSelector.getMarkupId());
            ((AjaxRequestTarget)target.get()).add((Component)this, this.getMarkupId());
        }
    }

    protected abstract Component getValueComponent(String var1, T var2);

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AjaxWizard.NewItemEvent) {
            Object item = ((AjaxWizard.NewItemEvent)event.getPayload()).getItem();
            AjaxRequestTarget target = ((AjaxWizard.NewItemEvent)event.getPayload()).getTarget();
            if (event.getPayload() instanceof AjaxWizard.NewItemFinishEvent) {
                Object old = this.getActualItem(item, this.listOfItems);
                int indexOf = this.listOfItems.size();
                if (old != null) {
                    indexOf = this.listOfItems.indexOf(old);
                    this.listOfItems.remove(old);
                }
                this.listOfItems.add(indexOf, item);
            }
            target.add(new Component[]{this});
            super.onEvent(event);
        } else if (event.getPayload() instanceof ListViewReload) {
            ListViewReload payload = (ListViewReload)event.getPayload();
            if (payload.getItems() != null) {
                this.listOfItems.clear();
                try {
                    this.listOfItems.addAll(payload.getItems());
                }
                catch (RuntimeException re) {
                    LOG.warn("Error reloading items", (Throwable)re);
                }
            }
            payload.getTarget().add(new Component[]{this});
        } else {
            super.onEvent(event);
        }
    }

    protected abstract T getActualItem(T var1, List<T> var2);

    protected ActionLinksTogglePanel<T> getTogglePanel() {
        return null;
    }

    public static class ListViewReload<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1509151005816590312L;
        private final AjaxRequestTarget target;
        private final List<T> items;

        public ListViewReload(AjaxRequestTarget target) {
            this.target = target;
            this.items = null;
        }

        public ListViewReload(List<T> items, AjaxRequestTarget target) {
            this.target = target;
            this.items = items;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public List<T> getItems() {
            return this.items;
        }
    }

    public static class Builder<T extends Serializable>
    extends WizardMgtPanel.Builder<T> {
        private static final long serialVersionUID = -3643771352897992172L;
        private IModel<? extends Collection<T>> model = Model.of(Collections.emptyList());
        private final List<String> includes = new ArrayList<String>();
        private final ActionsPanel<T> actions;
        private List<T> items;
        private CheckAvailability check = CheckAvailability.NONE;
        private boolean reuseItem = true;
        private final Class<T> reference;

        public Builder(Class<T> reference, PageReference pageRef) {
            super(pageRef);
            this.reference = reference;
            this.items = null;
            this.actions = new ActionsPanel("actions", null);
        }

        public Builder<T> setModel(IModel<? extends Collection<T>> model) {
            this.model = model;
            return this;
        }

        public Builder<T> setItems(List<T> items) {
            this.items = items;
            return this;
        }

        public Builder<T> addItem(T item) {
            if (item == null) {
                return this;
            }
            if (this.items == null) {
                this.items = new ArrayList<T>();
            }
            this.items.add(item);
            return this;
        }

        public Builder<T> withChecks(CheckAvailability check) {
            this.check = check;
            return this;
        }

        public void setReuseItem(boolean reuseItem) {
            this.reuseItem = reuseItem;
        }

        public Builder<T> includes(String ... includes) {
            for (String include : includes) {
                if (include == null || this.includes.contains(include)) continue;
                this.includes.add(include);
            }
            return this;
        }

        public Builder<T> addAction(ActionLink<T> link, ActionLink.ActionType type, String entitlements) {
            return this.addAction(link, type, entitlements, false);
        }

        public Builder<T> addAction(ActionLink<T> link, ActionLink.ActionType type, String entitlements, boolean onConfirm) {
            this.actions.add(link, type, entitlements, onConfirm).hideLabel();
            return this;
        }

        protected Component getValueComponent(String key, T bean) {
            Object value;
            LOG.debug("Processing field {}", (Object)key);
            try {
                value = PropertyResolver.getPropertyGetter((String)key, bean).invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Error retrieving value for field {}", (Object)key, (Object)e);
                value = "";
            }
            LOG.debug("Field value {}", value);
            return value == null ? new Label("field", (Serializable)((Object)"")) : new Label("field", (IModel)new ResourceModel(value.toString(), value.toString()));
        }

        protected T getActualItem(T item, List<T> list) {
            return (T)(item == null ? null : (Serializable)list.stream().filter(object -> item.equals(object)).findAny().orElse(null));
        }

        @Override
        protected WizardMgtPanel<T> newInstance(String id, boolean wizardInModal) {
            return new ListViewPanel<T>(id, this.items, this.reference, this.includes, this.actions, this.check, this.reuseItem, wizardInModal, this.model){
                private static final long serialVersionUID = -1715389337530657988L;

                @Override
                protected Component getValueComponent(String key, T bean) {
                    return this.getValueComponent(key, bean);
                }

                @Override
                protected T getActualItem(T item, List<T> list) {
                    return this.getActualItem(item, list);
                }

                @Override
                protected void customActionCallback(AjaxRequestTarget target) {
                    this.customActionCallback(target);
                }

                @Override
                protected void customActionOnFinishCallback(AjaxRequestTarget target) {
                    this.customActionOnFinishCallback(target);
                }

                @Override
                protected void customActionOnCancelCallback(AjaxRequestTarget target) {
                    this.customActionOnCancelCallback(target);
                }

                @Override
                protected ActionLinksTogglePanel<T> getTogglePanel() {
                    return this.getTogglePanel();
                }
            };
        }

        protected ActionLinksTogglePanel<T> getTogglePanel() {
            return null;
        }

        protected void customActionCallback(AjaxRequestTarget target) {
        }

        protected void customActionOnCancelCallback(AjaxRequestTarget target) {
        }

        protected void customActionOnFinishCallback(AjaxRequestTarget target) {
        }
    }

    public static enum CheckAvailability {
        NONE,
        AVAILABLE,
        DISABLED;

    }
}

