/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.io.IOUtils;

public class ImplementationModalPanel
extends AbstractModalPanel<ImplementationTO> {
    private static final long serialVersionUID = 5283548960927517342L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ImplementationRestClient restClient = new ImplementationRestClient();
    private final ImplementationTO implementation;
    private final ViewMode viewMode;
    private boolean create = false;

    public ImplementationModalPanel(BaseModal<ImplementationTO> modal, final ImplementationTO implementation, PageReference pageRef) {
        super(modal, pageRef);
        this.implementation = implementation;
        this.viewMode = implementation.getEngine() == ImplementationEngine.GROOVY ? ViewMode.GROOVY_BODY : (implementation.getType() == ImplementationType.REPORTLET || implementation.getType() == ImplementationType.ACCOUNT_RULE || implementation.getType() == ImplementationType.PASSWORD_RULE || implementation.getType() == ImplementationType.PULL_CORRELATION_RULE || implementation.getType() == ImplementationType.PUSH_CORRELATION_RULE ? ViewMode.JSON_BODY : ViewMode.JAVA_CLASS);
        this.create = implementation.getKey() == null;
        this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel<String>)new PropertyModel((Object)implementation, "key"), false).addRequiredLabel().setEnabled(this.create)});
        List<Object> classes = Collections.emptyList();
        if (this.viewMode == ViewMode.JAVA_CLASS) {
            Optional javaClasses = SyncopeConsoleSession.get().getPlatformInfo().getJavaImplInfo(implementation.getType());
            classes = javaClasses.isPresent() ? new ArrayList(((JavaImplInfo)javaClasses.get()).getClasses()) : new ArrayList();
        } else if (this.viewMode == ViewMode.JSON_BODY) {
            ClassPathScanImplementationLookup implementationLookup = (ClassPathScanImplementationLookup)SyncopeConsoleApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");
            switch (implementation.getType()) {
                case REPORTLET: {
                    classes = implementationLookup.getReportletConfs().keySet().stream().collect(Collectors.toList());
                    break;
                }
                case ACCOUNT_RULE: {
                    classes = implementationLookup.getAccountRuleConfs().keySet().stream().collect(Collectors.toList());
                    break;
                }
                case PASSWORD_RULE: {
                    classes = implementationLookup.getPasswordRuleConfs().keySet().stream().collect(Collectors.toList());
                    break;
                }
                case PULL_CORRELATION_RULE: {
                    classes = implementationLookup.getPullCorrelationRuleConfs().keySet().stream().collect(Collectors.toList());
                    break;
                }
                case PUSH_CORRELATION_RULE: {
                    classes = implementationLookup.getPushCorrelationRuleConfs().keySet().stream().collect(Collectors.toList());
                    break;
                }
            }
        }
        Collections.sort(classes);
        AjaxDropDownChoicePanel javaClass = new AjaxDropDownChoicePanel("javaClass", "Class", new PropertyModel((Object)implementation, "body"));
        javaClass.setNullValid(false);
        javaClass.setChoices(classes);
        javaClass.addRequiredLabel();
        javaClass.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        javaClass.setVisible(this.viewMode == ViewMode.JAVA_CLASS);
        this.add(new Component[]{javaClass});
        final AjaxDropDownChoicePanel jsonClass = new AjaxDropDownChoicePanel("jsonClass", "Class", new Model());
        jsonClass.setNullValid(false);
        jsonClass.setChoices(classes);
        jsonClass.addRequiredLabel();
        jsonClass.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        jsonClass.setVisible(this.viewMode == ViewMode.JSON_BODY);
        if (this.viewMode == ViewMode.JSON_BODY && StringUtils.isNotBlank((CharSequence)implementation.getBody())) {
            try {
                JsonNode node = MAPPER.readTree(implementation.getBody());
                if (node.has("@class")) {
                    jsonClass.setModelObject(node.get("@class").asText());
                }
            }
            catch (IOException e) {
                LOG.error("Could not parse as JSON payload: {}", (Object)implementation.getBody(), (Object)e);
            }
        }
        jsonClass.setReadOnly(jsonClass.getModelObject() != null);
        this.add(new Component[]{jsonClass});
        WebMarkupContainer groovyClassContainer = new WebMarkupContainer("groovyClassContainer");
        groovyClassContainer.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        groovyClassContainer.setVisible(this.viewMode != ViewMode.JAVA_CLASS);
        this.add(new Component[]{groovyClassContainer});
        if (StringUtils.isBlank((CharSequence)implementation.getBody()) && implementation.getEngine() == ImplementationEngine.GROOVY) {
            String templateClassName = null;
            switch (implementation.getType()) {
                case REPORTLET: {
                    templateClassName = "MyReportlet";
                    break;
                }
                case ACCOUNT_RULE: {
                    templateClassName = "MyAccountRule";
                    break;
                }
                case PASSWORD_RULE: {
                    templateClassName = "MyPasswordRule";
                    break;
                }
                case ITEM_TRANSFORMER: {
                    templateClassName = "MyItemTransformer";
                    break;
                }
                case TASKJOB_DELEGATE: {
                    templateClassName = "MySchedTaskJobDelegate";
                    break;
                }
                case RECON_FILTER_BUILDER: {
                    templateClassName = "MyReconFilterBuilder";
                    break;
                }
                case LOGIC_ACTIONS: {
                    templateClassName = "MyLogicActions";
                    break;
                }
                case PROPAGATION_ACTIONS: {
                    templateClassName = "MyPropagationActions";
                    break;
                }
                case PULL_ACTIONS: {
                    templateClassName = "MyPullActions";
                    break;
                }
                case PUSH_ACTIONS: {
                    templateClassName = "MyPushActions";
                    break;
                }
                case PULL_CORRELATION_RULE: {
                    templateClassName = "MyPullCorrelationRule";
                    break;
                }
                case PUSH_CORRELATION_RULE: {
                    templateClassName = "MyPushCorrelationRule";
                    break;
                }
                case VALIDATOR: {
                    templateClassName = "MyValidator";
                    break;
                }
                case RECIPIENTS_PROVIDER: {
                    templateClassName = "MyRecipientsProvider";
                    break;
                }
            }
            if (templateClassName != null) {
                try {
                    implementation.setBody(StringUtils.substringAfter((String)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/org/apache/syncope/client/console/implementations/" + templateClassName + ".groovy")), (String)"*/\n"));
                }
                catch (IOException e) {
                    LOG.error("Could not load the expected Groovy template {} for {}", new Object[]{templateClassName, implementation.getType(), e});
                }
            }
        }
        TextArea groovyClass = new TextArea("groovyClass", (IModel)new PropertyModel((Object)implementation, "body"));
        groovyClass.setMarkupId("groovyClass").setOutputMarkupPlaceholderTag(true);
        groovyClass.setVisible(this.viewMode != ViewMode.JAVA_CLASS);
        groovyClass.setRequired(true);
        groovyClassContainer.add(new Component[]{groovyClass});
        jsonClass.add(new Behavior[]{new AjaxEventBehavior("change"){
            private static final long serialVersionUID = 5538299138211283825L;

            protected void onEvent(AjaxRequestTarget target) {
                ClassPathScanImplementationLookup implementationLookup = (ClassPathScanImplementationLookup)SyncopeConsoleApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");
                Class<? extends ReportletConf> clazz = null;
                switch (implementation.getType()) {
                    case REPORTLET: {
                        clazz = implementationLookup.getReportletConfs().get(jsonClass.getModelObject());
                        break;
                    }
                    case ACCOUNT_RULE: {
                        clazz = implementationLookup.getAccountRuleConfs().get(jsonClass.getModelObject());
                        break;
                    }
                    case PASSWORD_RULE: {
                        clazz = implementationLookup.getPasswordRuleConfs().get(jsonClass.getModelObject());
                        break;
                    }
                    case PULL_CORRELATION_RULE: {
                        clazz = implementationLookup.getPullCorrelationRuleConfs().get(jsonClass.getModelObject());
                        break;
                    }
                    case PUSH_CORRELATION_RULE: {
                        clazz = implementationLookup.getPushCorrelationRuleConfs().get(jsonClass.getModelObject());
                        break;
                    }
                }
                if (clazz != null) {
                    try {
                        target.appendJavaScript((CharSequence)("editor.getDoc().setValue('" + MAPPER.writeValueAsString((Object)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) + "');"));
                    }
                    catch (Exception e) {
                        AbstractModalPanel.LOG.error("Could not generate a value for {}", jsonClass.getModelObject(), (Object)e);
                    }
                }
            }
        }});
    }

    @Override
    public ImplementationTO getItem() {
        return this.implementation;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.viewMode != ViewMode.JAVA_CLASS) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)("editor = CodeMirror.fromTextArea(document.getElementById('groovyClassForm').children['groovyClass'], {  readOnly: false,   lineNumbers: true,   lineWrapping: true,   matchBrackets: true,  autoCloseBrackets: true," + (this.viewMode == ViewMode.GROOVY_BODY ? "  mode: 'text/x-groovy'," : "") + "  autoRefresh: true});editor.on('change', updateTextArea);")));
        }
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            if (this.create) {
                this.restClient.create(this.implementation);
            } else {
                this.restClient.update(this.implementation);
            }
            this.modal.close((IPartialPageRequestHandler)target);
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
        }
        catch (Exception e) {
            LOG.error("While creating or updating AttrTO", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private static enum ViewMode {
        JAVA_CLASS,
        JSON_BODY,
        GROOVY_BODY;

    }
}

