/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ConnectorHistoryRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceHistoryConfTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class ConnInstanceHistoryConfDirectoryPanel
extends DirectoryPanel<ConnInstanceHistoryConfTO, ConnInstanceHistoryConfTO, CHConfProvider, ConnectorHistoryRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    protected final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;
    private final String entityKey;

    public ConnInstanceHistoryConfDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, String entityKey, PageReference pageRef) {
        super("first", pageRef, false, false);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.restClient = new ConnectorHistoryRestClient();
        this.setShowResultPage(false);
        this.disableCheckBoxes();
        this.entityKey = entityKey;
        this.initResultTable();
    }

    @Override
    protected List<IColumn<ConnInstanceHistoryConfTO, String>> getColumns() {
        ArrayList<IColumn<ConnInstanceHistoryConfTO, String>> columns = new ArrayList<IColumn<ConnInstanceHistoryConfTO, String>>();
        columns.add((IColumn<ConnInstanceHistoryConfTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<ConnInstanceHistoryConfTO, String>)new PropertyColumn((IModel)new StringResourceModel("creator", (Component)this), (Object)"creator", "creator"));
        columns.add((IColumn<ConnInstanceHistoryConfTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("creation", (Component)this), "creation", "creation"));
        return columns;
    }

    @Override
    public ActionsPanel<ConnInstanceHistoryConfTO> getActions(IModel<ConnInstanceHistoryConfTO> model) {
        ActionsPanel<ConnInstanceHistoryConfTO> panel = super.getActions(model);
        final ConnInstanceHistoryConfTO connHistoryConfTO = (ConnInstanceHistoryConfTO)model.getObject();
        panel.add(new ActionLink<ConnInstanceHistoryConfTO>(){
            private static final long serialVersionUID = -6745431735457245600L;

            @Override
            public void onClick(AjaxRequestTarget target, ConnInstanceHistoryConfTO modelObject) {
                ConnInstanceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                ConnInstanceHistoryConfDirectoryPanel.this.viewConfiguration(modelObject, target);
                target.add(new Component[]{ConnInstanceHistoryConfDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.VIEW, "CONNECTOR_HISTORY_LIST");
        panel.add(new ActionLink<ConnInstanceHistoryConfTO>(){
            private static final long serialVersionUID = -6745431735457245600L;

            @Override
            public void onClick(AjaxRequestTarget target, ConnInstanceHistoryConfTO modelObject) {
                try {
                    ((ConnectorHistoryRestClient)ConnInstanceHistoryConfDirectoryPanel.this.restClient).restore(modelObject.getKey());
                    ConnInstanceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                    target.add(new Component[]{ConnInstanceHistoryConfDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While restoring {}", (Object)connHistoryConfTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ConnInstanceHistoryConfDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.RESTORE, "CONNECTOR_HISTORY_RESTORE");
        panel.add(new ActionLink<ConnInstanceHistoryConfTO>(){
            private static final long serialVersionUID = -6745431735457245600L;

            @Override
            public void onClick(AjaxRequestTarget target, ConnInstanceHistoryConfTO modelObject) {
                try {
                    ((ConnectorHistoryRestClient)ConnInstanceHistoryConfDirectoryPanel.this.restClient).delete(modelObject.getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)ConnInstanceHistoryConfDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ConnInstanceHistoryConfDirectoryPanel.this.container});
                    ConnInstanceHistoryConfDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)connHistoryConfTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ConnInstanceHistoryConfDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CONNECTOR_HISTORY_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected String paginatorRowsKey() {
        return "connectorhistoryconf.paginator.rows";
    }

    protected abstract void viewConfiguration(ConnInstanceHistoryConfTO var1, AjaxRequestTarget var2);

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<ConnInstanceHistoryConfTO, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    @Override
    protected CHConfProvider dataProvider() {
        return new CHConfProvider(this.rows);
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class CHConfProvider
    extends DirectoryDataProvider<ConnInstanceHistoryConfTO> {
        private static final long serialVersionUID = -4402560904215049574L;
        private final SortableDataProviderComparator<ConnInstanceHistoryConfTO> comparator;

        public CHConfProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("creation", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ConnInstanceHistoryConfTO>(this);
        }

        public Iterator<ConnInstanceHistoryConfTO> iterator(long first, long count) {
            List<ConnInstanceHistoryConfTO> configurations = ((ConnectorHistoryRestClient)ConnInstanceHistoryConfDirectoryPanel.this.restClient).list(ConnInstanceHistoryConfDirectoryPanel.this.entityKey);
            Collections.sort(configurations, this.comparator);
            return configurations.iterator();
        }

        public long size() {
            return ((ConnectorHistoryRestClient)ConnInstanceHistoryConfDirectoryPanel.this.restClient).list(ConnInstanceHistoryConfDirectoryPanel.this.entityKey).size();
        }

        public IModel<ConnInstanceHistoryConfTO> model(ConnInstanceHistoryConfTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

