/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class ApplicationModalPanel
extends AbstractModalPanel<ApplicationTO> {
    private static final long serialVersionUID = 4575264480736377795L;
    private final ApplicationRestClient restClient = new ApplicationRestClient();
    private final ApplicationTO application;
    private final boolean create;

    public ApplicationModalPanel(ApplicationTO application, boolean create, BaseModal<ApplicationTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        this.application = application;
        this.create = create;
        modal.setFormModel(application);
        AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel<String>)new PropertyModel((Object)application, "key"), false);
        key.setReadOnly(!create);
        key.setRequired(true);
        this.add(new Component[]{key});
        AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", "description", (IModel<String>)new PropertyModel((Object)application, "description"), false);
        description.setRequired(false);
        this.add(new Component[]{description});
    }

    @Override
    public ApplicationTO getItem() {
        return this.application;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            if (this.create) {
                this.restClient.create(this.application);
            } else {
                this.restClient.update(this.application);
            }
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating/updating application", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

