/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ApplicationModalPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.PrivilegeDirectoryPanel;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ApplicationDirectoryPanel
extends DirectoryPanel<ApplicationTO, ApplicationTO, ApplicationDataProvider, ApplicationRestClient> {
    private static final long serialVersionUID = -5491515010207202168L;
    protected final BaseModal<PrivilegeTO> privilegeModal = new BaseModal<PrivilegeTO>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };

    protected ApplicationDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"APPLICATION_CREATE");
        this.setReadOnly(!SyncopeConsoleSession.get().owns("APPLICATION_UPDATE"));
        this.disableCheckBoxes();
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Medium);
        this.modal.addSubmitButton();
        this.setFooterVisibility(true);
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                ApplicationDirectoryPanel.this.updateResultTable(target);
                ApplicationDirectoryPanel.this.modal.show(false);
            }
        });
        this.privilegeModal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.privilegeModal);
        this.addOuterObject(new Component[]{this.privilegeModal});
        AjaxLink<Void> newApplLink = new AjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                ApplicationDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.new"));
                ApplicationDirectoryPanel.this.modal.setContent(new ApplicationModalPanel(new ApplicationTO(), true, ApplicationDirectoryPanel.this.modal, ApplicationDirectoryPanel.this.pageRef));
                ApplicationDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ApplicationDirectoryPanel.this.modal});
            }
        };
        ((WebMarkupContainer)this.get("container:content")).addOrReplace(new Component[]{newApplLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)newApplLink, (Action)RENDER, (String)"APPLICATION_CREATE");
        this.initResultTable();
    }

    @Override
    protected ApplicationDataProvider dataProvider() {
        return new ApplicationDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "application.paginator.rows";
    }

    @Override
    protected List<IColumn<ApplicationTO, String>> getColumns() {
        ArrayList<IColumn<ApplicationTO, String>> columns = new ArrayList<IColumn<ApplicationTO, String>>();
        columns.add((IColumn<ApplicationTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<ApplicationTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add((IColumn<ApplicationTO, String>)new AbstractColumn<ApplicationTO, String>((IModel)new ResourceModel("privileges")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ApplicationTO>> item, String componentId, IModel<ApplicationTO> rowModel) {
                item.add(new Component[]{new Label(componentId, (Serializable)((Object)("[" + ((ApplicationTO)rowModel.getObject()).getPrivileges().stream().map(EntityTO::getKey).collect(Collectors.joining(", ")) + "]")))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<ApplicationTO> getActions(final IModel<ApplicationTO> model) {
        ActionsPanel<ApplicationTO> panel = super.getActions(model);
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                ApplicationDirectoryPanel.this.modal.header((IModel)new StringResourceModel("any.edit", model));
                ApplicationDirectoryPanel.this.modal.setContent(new ApplicationModalPanel((ApplicationTO)model.getObject(), false, ApplicationDirectoryPanel.this.modal, ApplicationDirectoryPanel.this.pageRef));
                ApplicationDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ApplicationDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.EDIT, "APPLICATION_UPDATE");
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                target.add(new Component[]{ApplicationDirectoryPanel.this.privilegeModal.setContent(new PrivilegeDirectoryPanel(ApplicationDirectoryPanel.this.privilegeModal, (ApplicationTO)model.getObject(), ApplicationDirectoryPanel.this.pageRef))});
                ApplicationDirectoryPanel.this.privilegeModal.header((IModel)new StringResourceModel("application.privileges", (Component)ApplicationDirectoryPanel.this, (IModel)Model.of((Serializable)((Serializable)model.getObject()))));
                MetaDataRoleAuthorizationStrategy.authorize(ApplicationDirectoryPanel.this.privilegeModal.getForm(), (Action)Component.ENABLE, (String)"APPLICATION_UPDATE");
                ApplicationDirectoryPanel.this.privilegeModal.show(true);
            }
        }, ActionLink.ActionType.COMPOSE, "APPLICATION_UPDATE");
        panel.add(new ActionLink<ApplicationTO>(){
            private static final long serialVersionUID = 3766262567901552032L;

            @Override
            public void onClick(AjaxRequestTarget target, ApplicationTO ignore) {
                try {
                    ((ApplicationRestClient)ApplicationDirectoryPanel.this.restClient).delete(((ApplicationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().info((Serializable)((Object)ApplicationDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ApplicationDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting application {}", (Object)((ApplicationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)ApplicationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "APPLICATION_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    protected class ApplicationDataProvider
    extends DirectoryDataProvider<ApplicationTO> {
        private static final long serialVersionUID = 3124431855954382273L;
        private final SortableDataProviderComparator<ApplicationTO> comparator;
        private final ApplicationRestClient restClient;

        public ApplicationDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.restClient = new ApplicationRestClient();
            this.comparator = new SortableDataProviderComparator<ApplicationTO>(this);
        }

        public Iterator<ApplicationTO> iterator(long first, long count) {
            List<ApplicationTO> result = this.restClient.list();
            Collections.sort(result, this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return this.restClient.list().size();
        }

        public IModel<ApplicationTO> model(ApplicationTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<ApplicationTO, ApplicationTO, ApplicationRestClient> {
        private static final long serialVersionUID = 5530948153889495221L;

        public Builder(PageReference pageRef) {
            super(new ApplicationRestClient(), pageRef);
        }

        @Override
        protected WizardMgtPanel<ApplicationTO> newInstance(String id, boolean wizardInModal) {
            return new ApplicationDirectoryPanel(id, this);
        }
    }
}

