/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyTypeModalPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.TypesDirectoryPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class AnyTypesPanel
extends TypesDirectoryPanel<AnyTypeTO, AnyTypeProvider, AnyTypeRestClient> {
    private static final long serialVersionUID = 3905038169553185171L;

    public AnyTypesPanel(String id, PageReference pageRef) {
        super(id, false, pageRef);
        this.restClient = new AnyTypeRestClient();
        this.disableCheckBoxes();
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<AnyTypeTO>(new AnyTypeTO(), pageRef){
            private static final long serialVersionUID = -6388405037134399367L;

            @Override
            public WizardModalPanel<AnyTypeTO> build(String id, int index, AjaxWizard.Mode mode) {
                final AnyTypeTO modelObject = (AnyTypeTO)this.newModelObject();
                return new AnyTypeModalPanel(AnyTypesPanel.this.modal, modelObject, this.pageRef){
                    private static final long serialVersionUID = -6227956682141146095L;

                    @Override
                    public void onSubmit(AjaxRequestTarget target) {
                        try {
                            if (this.getOriginalItem() == null || StringUtils.isBlank((CharSequence)((AnyTypeTO)this.getOriginalItem()).getKey())) {
                                ((AnyTypeRestClient)AnyTypesPanel.this.restClient).create(modelObject);
                                SyncopeConsoleSession.get().refreshAuth();
                            } else {
                                ((AnyTypeRestClient)AnyTypesPanel.this.restClient).update(modelObject);
                            }
                            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                            AnyTypesPanel.this.updateResultTable(target);
                            this.modal.close((IPartialPageRequestHandler)target);
                        }
                        catch (Exception e) {
                            LOG.error("While creating or updating {}", (Object)modelObject, (Object)e);
                            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                };
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"ANYTYPE_CREATE");
    }

    @Override
    protected AnyTypeProvider dataProvider() {
        return new AnyTypeProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "anytype.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected List<IColumn<AnyTypeTO, String>> getColumns() {
        ArrayList<IColumn<AnyTypeTO, String>> columns = new ArrayList<IColumn<AnyTypeTO, String>>();
        for (Field field : AnyTypeTO.class.getDeclaredFields()) {
            if (field == null || Modifier.isStatic(field.getModifiers())) continue;
            final String fieldName = field.getName();
            if (field.getType().isArray() || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) {
                columns.add((IColumn<AnyTypeTO, String>)new PropertyColumn((IModel)new ResourceModel(field.getName()), field.getName()));
                continue;
            }
            if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                columns.add((IColumn<AnyTypeTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(field.getName()), field.getName(), field.getName()));
                continue;
            }
            columns.add((IColumn<AnyTypeTO, String>)new PropertyColumn<AnyTypeTO, String>((IModel)new ResourceModel(field.getName()), field.getName(), field.getName()){
                private static final long serialVersionUID = -6902459669035442212L;

                public String getCssClass() {
                    String css = super.getCssClass();
                    if ("key".equals(fieldName)) {
                        css = StringUtils.isBlank((CharSequence)css) ? "col-xs-1" : css + " col-xs-1";
                    }
                    return css;
                }
            });
        }
        return columns;
    }

    @Override
    public ActionsPanel<AnyTypeTO> getActions(final IModel<AnyTypeTO> model) {
        ActionsPanel<AnyTypeTO> panel = super.getActions(model);
        panel.add(new ActionLink<AnyTypeTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyTypeTO ignore) {
                AnyTypesPanel.this.send((IEventSink)AnyTypesPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "ANYTYPE_UPDATE");
        panel.add(new ActionLink<AnyTypeTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyTypeTO ignore) {
                try {
                    ((AnyTypeRestClient)AnyTypesPanel.this.restClient).delete(((AnyTypeTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().refreshAuth();
                    SyncopeConsoleSession.get().info((Serializable)((Object)AnyTypesPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AnyTypesPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                }
                ((BasePage)AnyTypesPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "ANYTYPE_DELETE", true);
        return panel;
    }

    protected final class AnyTypeProvider
    extends DirectoryDataProvider<AnyTypeTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<AnyTypeTO> comparator;

        private AnyTypeProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<AnyTypeTO>(this);
        }

        public Iterator<AnyTypeTO> iterator(long first, long count) {
            List<AnyTypeTO> list = ((AnyTypeRestClient)AnyTypesPanel.this.restClient).listAnyTypes();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((AnyTypeRestClient)AnyTypesPanel.this.restClient).list().size();
        }

        public IModel<AnyTypeTO> model(AnyTypeTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

