/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableAnyProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyDataProvider<A extends AnyTO>
extends DirectoryDataProvider<A> {
    private static final long serialVersionUID = 6267494272884913376L;
    protected static final Logger LOG = LoggerFactory.getLogger(AnyDataProvider.class);
    private final SortableAnyProviderComparator<A> comparator;
    private final AbstractAnyRestClient<A> restClient;
    protected String fiql;
    protected final boolean filtered;
    private final String realm;
    private final String type;
    private final PageReference pageRef;

    public AnyDataProvider(AbstractAnyRestClient<A> restClient, int paginatorRows, boolean filtered, String realm, String type, PageReference pageRef) {
        super(paginatorRows);
        this.restClient = restClient;
        this.filtered = filtered;
        switch (type) {
            case "USER": {
                this.setSort("username", SortOrder.ASCENDING);
                break;
            }
            case "GROUP": {
                this.setSort("name", SortOrder.ASCENDING);
                break;
            }
            default: {
                this.setSort("key", SortOrder.ASCENDING);
            }
        }
        this.comparator = new SortableAnyProviderComparator(this);
        this.realm = realm;
        this.type = type;
        this.pageRef = pageRef;
    }

    public Iterator<A> iterator(long first, long count) {
        List<Object> result;
        block2: {
            result = Collections.emptyList();
            try {
                int page = (int)first / this.paginatorRows;
                result = this.filtered ? (this.fiql == null ? Collections.emptyList() : this.restClient.search(this.realm, this.fiql, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), this.type)) : this.restClient.search(this.realm, null, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort(), this.type);
            }
            catch (Exception e) {
                LOG.error("While searching with FIQL {}", (Object)this.fiql, (Object)e);
                SyncopeConsoleSession.get().error((Serializable)((Object)e.getMessage()));
                Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
                if (!target.isPresent()) break block2;
                ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target.get());
            }
        }
        Collections.sort(result, this.comparator);
        return result.iterator();
    }

    public long size() {
        long result;
        block2: {
            result = 0L;
            try {
                result = this.filtered ? (this.fiql == null ? 0L : (long)this.restClient.count(this.realm, this.fiql, this.type)) : (long)this.restClient.count(this.realm, null, this.type);
            }
            catch (Exception e) {
                LOG.error("While requesting for size() with FIQL {}", (Object)this.fiql, (Object)e);
                SyncopeConsoleSession.get().error((Serializable)((Object)e.getMessage()));
                Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
                if (!target.isPresent()) break block2;
                ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target.get());
            }
        }
        return result;
    }

    public AnyDataProvider<A> setFIQL(String fiql) {
        this.fiql = fiql;
        return this;
    }

    public IModel<A> model(A object) {
        return new CompoundPropertyModel(object);
    }
}

