/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.batch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.RestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BatchResponseColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.lib.types.StatusPatchType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.beans.ExecuteQuery;
import org.apache.syncope.common.rest.api.service.AnyObjectService;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.GroupService;
import org.apache.syncope.common.rest.api.service.ReportService;
import org.apache.syncope.common.rest.api.service.TaskService;
import org.apache.syncope.common.rest.api.service.UserService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BatchContent<T extends Serializable, S>
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = 4114026480146090963L;
    protected static final Logger LOG = LoggerFactory.getLogger(BatchContent.class);

    public BatchContent(BaseModal<?> modal, List<T> items, List<IColumn<T, S>> columns, Collection<ActionLink.ActionType> actions, RestClient batchExecutor, String keyFieldName) {
        this("second", modal, items, columns, actions, batchExecutor, keyFieldName);
    }

    public BatchContent(String id, BaseModal<?> modal, final List<T> items, final List<IColumn<T, S>> columns, Collection<ActionLink.ActionType> actions, final RestClient batchExecutor, final String keyFieldName) {
        super(id);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final SortableDataProvider dataProvider = new SortableDataProvider<T, S>(){
            private static final long serialVersionUID = 5291903859908641954L;

            public Iterator<? extends T> iterator(long first, long count) {
                return items.iterator();
            }

            public long size() {
                return items.size();
            }

            public IModel<T> model(T object) {
                return new CompoundPropertyModel(object);
            }
        };
        container.add(new Component[]{new AjaxFallbackDefaultDataTable("selectedObjects", columns, (ISortableDataProvider)dataProvider, Integer.MAX_VALUE).setMarkupId("selectedObjects").setVisible(!CollectionUtils.isEmpty(items))});
        final ActionsPanel<Serializable> actionPanel = new ActionsPanel<Serializable>("actions", null);
        container.add(new Component[]{actionPanel});
        for (final ActionLink.ActionType action : actions) {
            actionPanel.add(new ActionLink<Serializable>(){
                private static final long serialVersionUID = -3722207913631435501L;

                @Override
                protected boolean statusCondition(Serializable modelObject) {
                    return !CollectionUtils.isEmpty((Collection)items);
                }

                @Override
                public void onClick(AjaxRequestTarget target, Serializable ignore) {
                    if (CollectionUtils.isEmpty((Collection)items)) {
                        throw new IllegalArgumentException("Invalid items");
                    }
                    try {
                        Map<String, String> results;
                        Serializable singleItem = (Serializable)items.iterator().next();
                        if (singleItem instanceof ExecTO) {
                            results = new HashMap<String, String>();
                            items.forEach(item -> {
                                ExecTO exec = (ExecTO)ExecTO.class.cast(item);
                                try {
                                    batchExecutor.getClass().getMethod("deleteExecution", String.class).invoke((Object)batchExecutor, exec.getKey());
                                    results.put(exec.getKey(), ExecStatus.SUCCESS.name());
                                }
                                catch (Exception e) {
                                    LOG.error("Error deleting execution {}", (Object)exec.getKey(), (Object)e);
                                    results.put(exec.getKey(), ExecStatus.FAILURE.name());
                                }
                            });
                        } else if (singleItem instanceof StatusBean) {
                            AbstractAnyRestClient anyRestClient = (AbstractAnyRestClient)AbstractAnyRestClient.class.cast(batchExecutor);
                            HashMap<String, List> beans = new HashMap<String, List>();
                            items.stream().map(bean -> (StatusBean)StatusBean.class.cast(bean)).forEachOrdered(sb -> {
                                List<StatusBean> sblist;
                                if (beans.containsKey(sb.getKey())) {
                                    sblist = (List)beans.get(sb.getKey());
                                } else {
                                    sblist = new ArrayList();
                                    beans.put(sb.getKey(), sblist);
                                }
                                sblist.add((StatusBean)sb);
                            });
                            results = new HashMap();
                            beans.forEach((key, value) -> {
                                String etag = anyRestClient.read((String)key).getETagValue();
                                switch (action) {
                                    case DEPROVISION: {
                                        results.putAll(anyRestClient.deassociate(ResourceDeassociationAction.DEPROVISION, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case UNASSIGN: {
                                        results.putAll(anyRestClient.deassociate(ResourceDeassociationAction.UNASSIGN, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case UNLINK: {
                                        results.putAll(anyRestClient.deassociate(ResourceDeassociationAction.UNLINK, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case ASSIGN: {
                                        results.putAll(anyRestClient.associate(ResourceAssociationAction.ASSIGN, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case LINK: {
                                        results.putAll(anyRestClient.associate(ResourceAssociationAction.LINK, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case PROVISION: {
                                        results.putAll(anyRestClient.associate(ResourceAssociationAction.PROVISION, etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case SUSPEND: {
                                        results.putAll(((UserRestClient)anyRestClient).suspend(etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                    case REACTIVATE: {
                                        results.putAll(((UserRestClient)anyRestClient).reactivate(etag, (String)key, (List<StatusBean>)value));
                                        break;
                                    }
                                }
                            });
                        } else {
                            BatchRequest batch = SyncopeConsoleSession.get().batch();
                            UserService batchUserService = (UserService)batch.getService(UserService.class);
                            GroupService batchGroupService = (GroupService)batch.getService(GroupService.class);
                            AnyObjectService batchAnyObjectService = (AnyObjectService)batch.getService(AnyObjectService.class);
                            UserService batchAnyService = singleItem instanceof UserTO ? batchUserService : (singleItem instanceof GroupTO ? batchGroupService : batchAnyObjectService);
                            TaskService batchTaskService = (TaskService)batch.getService(TaskService.class);
                            ReportService batchReportService = (ReportService)batch.getService(ReportService.class);
                            switch (action) {
                                case MUSTCHANGEPASSWORD: {
                                    items.forEach(item -> {
                                        UserTO user = (UserTO)item;
                                        UserPatch patch = new UserPatch();
                                        patch.setKey(user.getKey());
                                        patch.setMustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)(!user.isMustChangePassword() ? 1 : 0))).build());
                                        batchUserService.update(patch);
                                    });
                                    break;
                                }
                                case SUSPEND: {
                                    items.forEach(item -> {
                                        UserTO user = (UserTO)item;
                                        StatusPatch patch = new StatusPatch.Builder().key(user.getKey()).type(StatusPatchType.SUSPEND).onSyncope(true).resources((Collection)user.getResources()).build();
                                        batchUserService.status(patch);
                                    });
                                    break;
                                }
                                case REACTIVATE: {
                                    items.forEach(item -> {
                                        UserTO user = (UserTO)item;
                                        StatusPatch patch = new StatusPatch.Builder().key(user.getKey()).type(StatusPatchType.REACTIVATE).onSyncope(true).resources((Collection)user.getResources()).build();
                                        batchUserService.status(patch);
                                    });
                                    break;
                                }
                                case DELETE: {
                                    items.forEach(arg_0 -> 2.lambda$onClick$7(singleItem, (AnyService)batchAnyService, batchTaskService, batchReportService, arg_0));
                                    break;
                                }
                                case DRYRUN: {
                                    items.forEach(item -> {
                                        TaskTO task = (TaskTO)item;
                                        batchTaskService.execute(new ExecuteQuery.Builder().dryRun(true).key(task.getKey()).build());
                                    });
                                    break;
                                }
                                case EXECUTE: {
                                    items.forEach(item -> {
                                        if (singleItem instanceof TaskTO) {
                                            TaskTO task = (TaskTO)item;
                                            batchTaskService.execute(new ExecuteQuery.Builder().dryRun(false).key(task.getKey()).build());
                                        } else if (singleItem instanceof ReportTO) {
                                            ReportTO report = (ReportTO)item;
                                            batchReportService.execute(new ExecuteQuery.Builder().key(report.getKey()).build());
                                        }
                                    });
                                    break;
                                }
                            }
                            results = CastUtils.cast((Map)((Map)Map.class.cast(batchExecutor.getClass().getMethod("batch", BatchRequest.class).invoke((Object)batchExecutor, batch))));
                            if (singleItem instanceof UserTO) {
                                UserRestClient userRestClient = (UserRestClient)UserRestClient.class.cast(batchExecutor);
                                for (int i = 0; i < items.size(); ++i) {
                                    items.set(i, userRestClient.read(((UserTO)items.get(i)).getKey()));
                                }
                            }
                        }
                        ArrayList newColumnList = new ArrayList(columns);
                        newColumnList.add(newColumnList.size(), new BatchResponseColumn(results, keyFieldName));
                        container.addOrReplace(new Component[]{new AjaxFallbackDefaultDataTable("selectedObjects", newColumnList, (ISortableDataProvider)dataProvider, Integer.MAX_VALUE).setVisible(!items.isEmpty())});
                        actionPanel.setEnabled(false);
                        actionPanel.setVisible(false);
                        target.add(new Component[]{container});
                        target.add(new Component[]{actionPanel});
                        SyncopeConsoleSession.get().info((Serializable)((Object)BatchContent.this.getString("operation_succeeded")));
                    }
                    catch (Exception e) {
                        LOG.error("Batch failure", (Throwable)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)("Operation " + action.getActionId() + " not supported")));
                    }
                    ((BasePage)BatchContent.this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }

                private static /* synthetic */ void lambda$onClick$7(Serializable singleItem, AnyService batchAnyService, TaskService batchTaskService, ReportService batchReportService, Serializable item) {
                    if (singleItem instanceof AnyTO) {
                        AnyTO any = (AnyTO)item;
                        batchAnyService.delete(any.getKey());
                    } else if (singleItem instanceof TaskTO) {
                        TaskTO task = (TaskTO)item;
                        batchTaskService.delete(TaskType.fromTOClass(task.getClass()), task.getKey());
                    } else if (singleItem instanceof ReportTO) {
                        ReportTO report = (ReportTO)item;
                        batchReportService.delete(report.getKey());
                    } else {
                        LOG.warn("Unsupported for DELETE: {}", (Object)singleItem.getClass().getName());
                    }
                }
            }, action, "CONFIGURATION_LIST").hideLabel();
        }
    }
}

