/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.flowable.task;

import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.flowable.task.AbstractFlowableServiceTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PasswordReset
extends AbstractFlowableServiceTask {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserDataBinder dataBinder;

    @Override
    protected void doExecute(String executionId) {
        User user = (User)this.engine.getRuntimeService().getVariable(executionId, "user", User.class);
        String token = (String)this.engine.getRuntimeService().getVariable(executionId, "token", String.class);
        String password = (String)this.engine.getRuntimeService().getVariable(executionId, "password", String.class);
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(user.getKey());
        userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build());
        PropagationByResource propByRes = this.dataBinder.update(user, userPatch);
        this.engine.getRuntimeService().setVariable(executionId, "user", (Object)user);
        this.engine.getRuntimeService().setVariable(executionId, "userPatch", (Object)userPatch);
        this.engine.getRuntimeService().setVariable(executionId, "propByResource", (Object)propByRes);
    }
}

