/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.flowable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.common.lib.to.WorkflowFormPropertyTO;
import org.apache.syncope.common.lib.to.WorkflowFormTO;
import org.apache.syncope.common.lib.to.WorkflowTaskTO;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.WorkflowFormPropertyType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.spring.BeanUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowDefinitionFormat;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.flowable.FlowableDeployUtils;
import org.apache.syncope.core.workflow.flowable.spring.DomainProcessEngine;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.engine.form.FormProperty;
import org.flowable.engine.form.FormType;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class FlowableUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final String[] PROPERTY_IGNORE_PROPS = new String[]{"type"};
    public static final String WF_PROCESS_ID = "userWorkflow";
    public static final String USER = "user";
    public static final String WF_EXECUTOR = "wfExecutor";
    public static final String FORM_SUBMITTER = "formSubmitter";
    public static final String USER_TO = "userTO";
    public static final String ENABLED = "enabled";
    public static final String USER_PATCH = "userPatch";
    public static final String EMAIL_KIND = "emailKind";
    public static final String TASK = "task";
    public static final String TOKEN = "token";
    public static final String PASSWORD = "password";
    public static final String PROP_BY_RESOURCE = "propByResource";
    public static final String PROPAGATE_ENABLE = "propagateEnable";
    public static final String ENCRYPTED_PWD = "encryptedPwd";
    public static final String TASK_IS_FORM = "taskIsForm";
    public static final String MODEL_DATA_JSON_MODEL = "model";
    public static final String STORE_PASSWORD = "storePassword";
    public static final String EVENT = "event";
    @Resource(name="adminUser")
    protected String adminUser;
    @Autowired
    protected DomainProcessEngine engine;

    public String getPrefix() {
        return "ACT_";
    }

    protected void throwException(FlowableException e, String defaultMessage) {
        if (e.getCause() != null) {
            if (e.getCause().getCause() instanceof SyncopeClientException) {
                throw (SyncopeClientException)e.getCause().getCause();
            }
            if (e.getCause().getCause() instanceof ParsingValidationException) {
                throw (ParsingValidationException)e.getCause().getCause();
            }
            if (e.getCause().getCause() instanceof InvalidEntityException) {
                throw (InvalidEntityException)e.getCause().getCause();
            }
        }
        throw new WorkflowException(defaultMessage, (Throwable)e);
    }

    protected void updateStatus(User user) {
        List tasks = ((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(user.getWorkflowId())).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.warn("While setting user status: unexpected task number ({})", (Object)tasks.size());
        } else {
            user.setStatus(((Task)tasks.get(0)).getTaskDefinitionKey());
        }
    }

    protected String getFormTask(User user) {
        String result = null;
        List tasks = ((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(user.getWorkflowId())).list();
        if (tasks.isEmpty() || tasks.size() > 1) {
            LOG.debug("While checking if form task: unexpected task number ({})", (Object)tasks.size());
        } else {
            try {
                TaskFormData formData = this.engine.getFormService().getTaskFormData(((Task)tasks.get(0)).getId());
                if (formData != null && !formData.getFormProperties().isEmpty()) {
                    result = ((Task)tasks.get(0)).getId();
                }
            }
            catch (FlowableException e) {
                LOG.warn("Could not get task form data", (Throwable)e);
            }
        }
        return result;
    }

    protected Set<String> getPerformedTasks(User user) {
        HashSet<String> result = new HashSet<String>();
        this.engine.getHistoryService().createHistoricActivityInstanceQuery().executionId(user.getWorkflowId()).list().forEach(task -> result.add(task.getActivityId()));
        return result;
    }

    protected void saveForFormSubmit(User user, String password, PropagationByResource propByRes) {
        String formTaskId = this.getFormTask(user);
        if (formTaskId != null) {
            UserTO userTO = (UserTO)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), USER_TO, UserTO.class);
            if (userTO != null) {
                userTO.setKey(user.getKey());
                userTO.setCreationDate(user.getCreationDate());
                userTO.setLastChangeDate(user.getLastChangeDate());
                if (password == null) {
                    String encryptedPwd = (String)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), ENCRYPTED_PWD, String.class);
                    if (encryptedPwd != null) {
                        userTO.setPassword(this.decrypt(encryptedPwd));
                    }
                } else {
                    userTO.setPassword(password);
                }
                this.engine.getRuntimeService().setVariable(user.getWorkflowId(), USER_TO, (Object)userTO);
            }
            this.engine.getTaskService().setVariableLocal(formTaskId, TASK_IS_FORM, (Object)Boolean.TRUE);
            this.engine.getRuntimeService().setVariable(user.getWorkflowId(), PROP_BY_RESOURCE, (Object)propByRes);
            if (propByRes != null) {
                propByRes.clear();
            }
            if (password != null) {
                this.engine.getRuntimeService().setVariable(user.getWorkflowId(), ENCRYPTED_PWD, (Object)this.encrypt(password));
            }
        }
    }

    protected WorkflowResult<Pair<String, Boolean>> doCreate(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(WF_EXECUTOR, AuthContextUtils.getUsername());
        variables.put(USER_TO, userTO);
        variables.put(ENABLED, enabled);
        variables.put(STORE_PASSWORD, storePassword);
        ProcessInstance processInstance = null;
        try {
            processInstance = this.engine.getRuntimeService().startProcessInstanceByKey(WF_PROCESS_ID, variables);
        }
        catch (FlowableException e) {
            this.throwException(e, "While starting userWorkflow instance");
        }
        User user = (User)this.engine.getRuntimeService().getVariable(processInstance.getProcessInstanceId(), USER, User.class);
        Boolean updatedEnabled = (Boolean)this.engine.getRuntimeService().getVariable(processInstance.getProcessInstanceId(), ENABLED, Boolean.class);
        if (updatedEnabled != null) {
            user.setSuspended(Boolean.valueOf(updatedEnabled == false));
        }
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        this.updateStatus(user);
        user = (User)this.userDAO.save((Any)user);
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(processInstance.getProcessInstanceId(), PROPAGATE_ENABLE, Boolean.class);
        if (propagateEnable == null) {
            propagateEnable = enabled;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(user.getKey()));
        this.saveForFormSubmit(user, userTO.getPassword(), propByRes);
        Set<String> tasks = this.getPerformedTasks(user);
        return new WorkflowResult((Object)Pair.of((Object)user.getKey(), (Object)propagateEnable), propByRes, tasks);
    }

    protected Set<String> doExecuteTask(User user, String task, Map<String, Object> moreVariables) {
        Set<String> preTasks = this.getPerformedTasks(user);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(WF_EXECUTOR, AuthContextUtils.getUsername());
        variables.put(TASK, task);
        BeanUtils.copyProperties((Object)user, (Object)this.entityFactory.newEntity(User.class));
        variables.put(USER, user);
        if (moreVariables != null && !moreVariables.isEmpty()) {
            variables.putAll(moreVariables);
        }
        if (StringUtils.isBlank((CharSequence)user.getWorkflowId())) {
            throw new WorkflowException((Throwable)new NotFoundException("Empty workflow id for " + user));
        }
        List tasks = ((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(user.getWorkflowId())).list();
        if (tasks.size() == 1) {
            try {
                this.engine.getTaskService().complete(((Task)tasks.get(0)).getId(), variables);
            }
            catch (FlowableException e) {
                this.throwException(e, "While completing task '" + ((Task)tasks.get(0)).getName() + "' for " + user);
            }
        } else {
            LOG.warn("Expected a single task, found {}", (Object)tasks.size());
        }
        Set<String> postTasks = this.getPerformedTasks(user);
        postTasks.removeAll(preTasks);
        postTasks.add(task);
        return postTasks;
    }

    protected WorkflowResult<String> doActivate(User user, String token) {
        Set<String> tasks = this.doExecuteTask(user, "activate", Collections.singletonMap(TOKEN, token));
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, tasks);
    }

    protected WorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User user, UserPatch userPatch) {
        Set<String> tasks = this.doExecuteTask(user, "update", Collections.singletonMap(USER_PATCH, userPatch));
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROP_BY_RESOURCE, PropagationByResource.class);
        this.saveForFormSubmit(updated, userPatch.getPassword() == null ? null : (String)userPatch.getPassword().getValue(), propByRes);
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROPAGATE_ENABLE, Boolean.class);
        return new WorkflowResult((Object)Pair.of((Object)userPatch, (Object)propagateEnable), propByRes, tasks);
    }

    public WorkflowResult<String> requestCertify(User user) {
        String authUser = AuthContextUtils.getUsername();
        this.engine.getRuntimeService().setVariable(user.getWorkflowId(), FORM_SUBMITTER, (Object)authUser);
        Set<String> performedTasks = this.doExecuteTask(user, "request-certify", null);
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROP_BY_RESOURCE, PropagationByResource.class);
        this.saveForFormSubmit(user, null, propByRes);
        return new WorkflowResult((Object)user.getKey(), null, performedTasks);
    }

    protected WorkflowResult<String> doSuspend(User user) {
        Set<String> performedTasks = this.doExecuteTask(user, "suspend", null);
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, performedTasks);
    }

    protected WorkflowResult<String> doReactivate(User user) {
        Set<String> performedTasks = this.doExecuteTask(user, "reactivate", null);
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        return new WorkflowResult((Object)updated.getKey(), null, performedTasks);
    }

    protected void doRequestPasswordReset(User user) {
        HashMap<String, Object> variables = new HashMap<String, Object>(2);
        variables.put(USER_TO, this.dataBinder.getUserTO(user, true));
        variables.put(EVENT, "requestPasswordReset");
        this.doExecuteTask(user, "requestPasswordReset", variables);
        this.userDAO.save((Any)user);
    }

    protected WorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User user, String token, String password) {
        HashMap<String, Object> variables = new HashMap<String, Object>(4);
        variables.put(TOKEN, token);
        variables.put(PASSWORD, password);
        variables.put(USER_TO, this.dataBinder.getUserTO(user, true));
        variables.put(EVENT, "confirmPasswordReset");
        Set<String> tasks = this.doExecuteTask(user, "confirmPasswordReset", variables);
        this.userDAO.save((Any)user);
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROP_BY_RESOURCE, PropagationByResource.class);
        UserPatch updatedPatch = (UserPatch)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), USER_PATCH, UserPatch.class);
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROPAGATE_ENABLE, Boolean.class);
        return new WorkflowResult((Object)Pair.of((Object)updatedPatch, (Object)propagateEnable), propByRes, tasks);
    }

    protected void doDelete(User user) {
        this.doExecuteTask(user, "delete", null);
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceKeys(user.getKey()));
        this.saveForFormSubmit(user, null, propByRes);
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(user.getWorkflowId()).active().list().isEmpty()) {
            this.userDAO.delete(user.getKey());
            if (!this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(user.getWorkflowId()).list().isEmpty()) {
                this.engine.getHistoryService().deleteHistoricProcessInstance(user.getWorkflowId());
            }
        } else {
            this.updateStatus(user);
            this.userDAO.save((Any)user);
        }
    }

    public WorkflowResult<String> execute(UserTO userTO, String taskId) {
        User user = (User)this.userDAO.authFind(userTO.getKey());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(USER_TO, userTO);
        Set<String> performedTasks = this.doExecuteTask(user, taskId, variables);
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROP_BY_RESOURCE, PropagationByResource.class);
        this.saveForFormSubmit(updated, userTO.getPassword(), propByRes);
        return new WorkflowResult((Object)updated.getKey(), null, performedTasks);
    }

    protected WorkflowFormPropertyType fromFlowableFormType(FormType flowableFormType) {
        WorkflowFormPropertyType result = WorkflowFormPropertyType.String;
        if ("string".equals(flowableFormType.getName())) {
            result = WorkflowFormPropertyType.String;
        }
        if ("long".equals(flowableFormType.getName())) {
            result = WorkflowFormPropertyType.Long;
        }
        if ("enum".equals(flowableFormType.getName())) {
            result = WorkflowFormPropertyType.Enum;
        }
        if ("date".equals(flowableFormType.getName())) {
            result = WorkflowFormPropertyType.Date;
        }
        if ("boolean".equals(flowableFormType.getName())) {
            result = WorkflowFormPropertyType.Boolean;
        }
        return result;
    }

    protected WorkflowFormTO getFormTO(Task task) {
        return this.getFormTO(task, this.engine.getFormService().getTaskFormData(task.getId()));
    }

    protected WorkflowFormTO getFormTO(Task task, TaskFormData fd) {
        WorkflowFormTO formTO = this.getFormTO(task.getProcessInstanceId(), task.getId(), fd.getFormKey(), fd.getFormProperties());
        BeanUtils.copyProperties((Object)task, (Object)formTO);
        return formTO;
    }

    protected WorkflowFormTO getFormTO(HistoricTaskInstance task) {
        ArrayList<HistoricFormPropertyEntity> props = new ArrayList<HistoricFormPropertyEntity>();
        this.engine.getHistoryService().createHistoricDetailQuery().taskId(task.getId()).list().stream().filter(historicDetail -> historicDetail instanceof HistoricFormPropertyEntity).forEachOrdered(historicDetail -> props.add((HistoricFormPropertyEntity)historicDetail));
        WorkflowFormTO formTO = this.getHistoricFormTO(task.getProcessInstanceId(), task.getId(), task.getFormKey(), props);
        BeanUtils.copyProperties((Object)task, (Object)formTO);
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.engine.getHistoryService().createHistoricActivityInstanceQuery().executionId(task.getExecutionId()).activityType("userTask").activityName(task.getName()).singleResult();
        if (historicActivityInstance != null) {
            formTO.setCreateTime(historicActivityInstance.getStartTime());
            formTO.setDueDate(historicActivityInstance.getEndTime());
        }
        return formTO;
    }

    protected WorkflowFormTO getHistoricFormTO(String processInstanceId, String taskId, String formKey, List<HistoricFormPropertyEntity> props) {
        WorkflowFormTO formTO = new WorkflowFormTO();
        User user = (User)this.userDAO.findByWorkflowId(processInstanceId);
        if (user == null) {
            throw new NotFoundException("User with workflow id " + processInstanceId);
        }
        formTO.setUsername(user.getUsername());
        formTO.setTaskId(taskId);
        formTO.setKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(processInstanceId, USER_TO, UserTO.class));
        formTO.setUserPatch((UserPatch)this.engine.getRuntimeService().getVariable(processInstanceId, USER_PATCH, UserPatch.class));
        props.stream().map(prop -> {
            WorkflowFormPropertyTO propertyTO = new WorkflowFormPropertyTO();
            propertyTO.setId(prop.getPropertyId());
            propertyTO.setName(prop.getPropertyId());
            propertyTO.setValue(prop.getPropertyValue());
            return propertyTO;
        }).forEachOrdered(propertyTO -> formTO.getProperties().add(propertyTO));
        return formTO;
    }

    protected WorkflowFormTO getFormTO(String processInstanceId, String taskId, String formKey, List<FormProperty> properties) {
        WorkflowFormTO formTO = new WorkflowFormTO();
        User user = (User)this.userDAO.findByWorkflowId(processInstanceId);
        if (user == null) {
            throw new NotFoundException("User with workflow id " + processInstanceId);
        }
        formTO.setUsername(user.getUsername());
        formTO.setTaskId(taskId);
        formTO.setKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(processInstanceId, USER_TO, UserTO.class));
        formTO.setUserPatch((UserPatch)this.engine.getRuntimeService().getVariable(processInstanceId, USER_PATCH, UserPatch.class));
        properties.stream().map(fProp -> {
            WorkflowFormPropertyTO propertyTO = new WorkflowFormPropertyTO();
            BeanUtils.copyProperties((Object)fProp, (Object)propertyTO, (String[])PROPERTY_IGNORE_PROPS);
            propertyTO.setType(this.fromFlowableFormType(fProp.getType()));
            if (propertyTO.getType() == WorkflowFormPropertyType.Date) {
                propertyTO.setDatePattern((String)fProp.getType().getInformation("datePattern"));
            }
            if (propertyTO.getType() == WorkflowFormPropertyType.Enum) {
                propertyTO.getEnumValues().putAll((Map)fProp.getType().getInformation("values"));
            }
            return propertyTO;
        }).forEachOrdered(propertyTO -> formTO.getProperties().add(propertyTO));
        return formTO;
    }

    @Transactional(readOnly=true)
    public Pair<Integer, List<WorkflowFormTO>> getForms(int page, int size, List<OrderByClause> orderByClauses) {
        Pair<Integer, List<WorkflowFormTO>> forms = null;
        String authUser = AuthContextUtils.getUsername();
        if (this.adminUser.equals(authUser)) {
            forms = this.getForms((TaskQuery)this.engine.getTaskService().createTaskQuery().taskVariableValueEquals(TASK_IS_FORM, (Object)Boolean.TRUE), page, size, orderByClauses);
        } else {
            User user = this.userDAO.findByUsername(authUser);
            if (user == null) {
                throw new NotFoundException("Syncope User " + authUser);
            }
            forms = this.getForms(((TaskQuery)this.engine.getTaskService().createTaskQuery().taskVariableValueEquals(TASK_IS_FORM, (Object)Boolean.TRUE)).taskCandidateOrAssigned(user.getKey()), page, size, orderByClauses);
            ArrayList candidateGroups = new ArrayList();
            this.userDAO.findAllGroupNames(user).forEach(group -> candidateGroups.add(group));
            if (!candidateGroups.isEmpty()) {
                forms = this.getForms((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskVariableValueEquals(TASK_IS_FORM, (Object)Boolean.TRUE)).taskCandidateGroupIn(candidateGroups), page, size, orderByClauses);
            }
        }
        return forms == null ? Pair.of((Object)0, Collections.emptyList()) : forms;
    }

    protected Pair<Integer, List<WorkflowFormTO>> getForms(TaskQuery query, int page, int size, List<OrderByClause> orderByClauses) {
        TaskQuery sortedQuery = query;
        for (OrderByClause clause : orderByClauses) {
            boolean ack = true;
            switch (clause.getField().trim()) {
                case "taskId": {
                    sortedQuery = (TaskQuery)sortedQuery.orderByTaskId();
                    break;
                }
                case "createTime": {
                    sortedQuery = (TaskQuery)sortedQuery.orderByTaskCreateTime();
                    break;
                }
                case "dueDate": {
                    sortedQuery = (TaskQuery)sortedQuery.orderByTaskDueDate();
                    break;
                }
                case "owner": {
                    sortedQuery = (TaskQuery)sortedQuery.orderByTaskOwner();
                    break;
                }
                default: {
                    LOG.warn("Form sort request by {}: unsupported, ignoring", (Object)clause.getField().trim());
                    ack = false;
                }
            }
            if (!ack) continue;
            if (clause.getDirection() == OrderByClause.Direction.ASC) {
                sortedQuery = (TaskQuery)sortedQuery.asc();
                continue;
            }
            sortedQuery = (TaskQuery)sortedQuery.desc();
        }
        List result = sortedQuery.listPage(size * (page <= 0 ? 0 : page - 1), size).stream().map(task -> {
            if (task instanceof HistoricTaskInstance) {
                return this.getFormTO((HistoricTaskInstance)task);
            }
            return this.getFormTO((Task)task);
        }).collect(Collectors.toList());
        return Pair.of((Object)((int)query.count()), result);
    }

    public WorkflowFormTO getForm(String workflowId) {
        TaskFormData formData;
        Task task;
        try {
            task = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(workflowId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading form for workflow instance " + workflowId, (Throwable)e);
        }
        try {
            formData = this.engine.getFormService().getTaskFormData(task.getId());
        }
        catch (FlowableException e) {
            LOG.debug("No form found for task {}", (Object)task.getId(), (Object)e);
            formData = null;
        }
        WorkflowFormTO result = null;
        if (formData != null && !formData.getFormProperties().isEmpty()) {
            result = this.getFormTO(task);
        }
        return result;
    }

    protected Pair<Task, TaskFormData> checkTask(String taskId, String authUser) {
        User user;
        TaskFormData formData;
        Task task;
        try {
            task = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
            if (task == null) {
                throw new FlowableException("NULL result");
            }
        }
        catch (FlowableException e) {
            throw new NotFoundException("Flowable Task " + taskId, (Exception)((Object)e));
        }
        try {
            formData = this.engine.getFormService().getTaskFormData(task.getId());
        }
        catch (FlowableException e) {
            throw new NotFoundException("Form for Flowable Task " + taskId, (Exception)((Object)e));
        }
        if (!this.adminUser.equals(authUser) && (user = this.userDAO.findByUsername(authUser)) == null) {
            throw new NotFoundException("Syncope User " + authUser);
        }
        return Pair.of((Object)task, (Object)formData);
    }

    public WorkflowFormTO claimForm(String taskId) {
        Task task;
        List tasksForUser;
        String authUser = AuthContextUtils.getUsername();
        Pair<Task, TaskFormData> checked = this.checkTask(taskId, authUser);
        if (!this.adminUser.equals(authUser) && (tasksForUser = ((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskId(taskId)).taskCandidateUser(authUser)).list()).isEmpty()) {
            throw new WorkflowException((Throwable)new IllegalArgumentException(authUser + " is not candidate for task " + taskId));
        }
        try {
            this.engine.getTaskService().setOwner(taskId, authUser);
            task = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading task " + taskId, (Throwable)e);
        }
        return this.getFormTO(task, (TaskFormData)checked.getValue());
    }

    private Map<String, String> getPropertiesForSubmit(WorkflowFormTO form) {
        HashMap props = new HashMap();
        form.getProperties().stream().filter(prop -> prop.isWritable()).forEachOrdered(prop -> props.put(prop.getId(), prop.getValue()));
        return Collections.unmodifiableMap(props);
    }

    public WorkflowResult<UserPatch> submitForm(WorkflowFormTO form) {
        String authUser = AuthContextUtils.getUsername();
        Pair<Task, TaskFormData> checked = this.checkTask(form.getTaskId(), authUser);
        if (!((Task)checked.getKey()).getOwner().equals(authUser)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Task " + form.getTaskId() + " assigned to " + ((Task)checked.getKey()).getOwner() + " but submitted by " + authUser));
        }
        User user = (User)this.userDAO.findByWorkflowId(((Task)checked.getKey()).getProcessInstanceId());
        if (user == null) {
            throw new NotFoundException("User with workflow id " + ((Task)checked.getKey()).getProcessInstanceId());
        }
        Set<String> preTasks = this.getPerformedTasks(user);
        try {
            this.engine.getFormService().submitTaskFormData(form.getTaskId(), this.getPropertiesForSubmit(form));
            this.engine.getRuntimeService().setVariable(user.getWorkflowId(), FORM_SUBMITTER, (Object)authUser);
        }
        catch (FlowableException e) {
            this.throwException(e, "While submitting form for task " + form.getTaskId());
        }
        Set<String> postTasks = this.getPerformedTasks(user);
        postTasks.removeAll(preTasks);
        postTasks.add(form.getTaskId());
        this.updateStatus(user);
        User updated = (User)this.userDAO.save((Any)user);
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), PROP_BY_RESOURCE, PropagationByResource.class);
        String clearPassword = null;
        String encryptedPwd = (String)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), ENCRYPTED_PWD, String.class);
        if (StringUtils.isNotBlank((CharSequence)encryptedPwd)) {
            clearPassword = this.decrypt(encryptedPwd);
        }
        this.saveForFormSubmit(user, clearPassword, propByRes);
        UserPatch userPatch = (UserPatch)this.engine.getRuntimeService().getVariable(user.getWorkflowId(), USER_PATCH, UserPatch.class);
        if (userPatch == null) {
            userPatch = new UserPatch();
            userPatch.setKey(updated.getKey());
            userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).value((Object)clearPassword)).build());
            if (propByRes != null) {
                userPatch.getPassword().getResources().addAll(propByRes.get(ResourceOperation.CREATE));
            }
        }
        return new WorkflowResult((Object)userPatch, propByRes, postTasks);
    }

    protected void navigateAvailableTasks(FlowElement flow, List<String> availableTasks) {
        if (flow instanceof Gateway) {
            ((Gateway)flow).getOutgoingFlows().forEach(subflow -> this.navigateAvailableTasks((FlowElement)subflow, availableTasks));
        } else if (flow instanceof SequenceFlow) {
            availableTasks.add(((SequenceFlow)flow).getTargetRef());
        } else {
            LOG.debug("Unexpected flow found: {}", (Object)flow);
        }
    }

    public List<WorkflowTaskTO> getAvailableTasks(String workflowId) {
        ArrayList availableTasks = new ArrayList();
        try {
            Task currentTask = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(workflowId)).singleResult();
            Process process = (Process)this.engine.getRepositoryService().getBpmnModel(this.getProcessDefinitionByKey(WF_PROCESS_ID).getId()).getProcesses().get(0);
            process.getFlowElements().stream().filter(SequenceFlow.class::isInstance).map(SequenceFlow.class::cast).filter(sequenceFlow -> sequenceFlow.getSourceRef().equals(currentTask.getTaskDefinitionKey())).forEach(sequenceFlow -> {
                FlowElement target = process.getFlowElement(sequenceFlow.getTargetRef(), true);
                this.navigateAvailableTasks(target, availableTasks);
            });
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading available tasks for workflow instance " + workflowId, (Throwable)e);
        }
        return availableTasks.stream().map(input -> {
            WorkflowTaskTO workflowTaskTO = new WorkflowTaskTO();
            workflowTaskTO.setName(input);
            return workflowTaskTO;
        }).collect(Collectors.toList());
    }

    protected Model getModel(ProcessDefinition procDef) {
        try {
            Model model = (Model)this.engine.getRepositoryService().createModelQuery().deploymentId(procDef.getDeploymentId()).singleResult();
            if (model == null) {
                throw new NotFoundException("Could not find Model for deployment " + procDef.getDeploymentId());
            }
            return model;
        }
        catch (Exception e) {
            throw new WorkflowException("While accessing process " + procDef.getKey(), (Throwable)e);
        }
    }

    public List<WorkflowDefinitionTO> getDefinitions() {
        try {
            return this.engine.getRepositoryService().createProcessDefinitionQuery().latestVersion().list().stream().map(procDef -> {
                WorkflowDefinitionTO defTO = new WorkflowDefinitionTO();
                defTO.setKey(procDef.getKey());
                defTO.setName(procDef.getName());
                try {
                    defTO.setModelId(this.getModel((ProcessDefinition)procDef).getId());
                }
                catch (NotFoundException e) {
                    LOG.warn("No model found for definition {}, ignoring", (Object)procDef.getDeploymentId(), (Object)e);
                }
                defTO.setMain(WF_PROCESS_ID.equals(procDef.getKey()));
                return defTO;
            }).collect(Collectors.toList());
        }
        catch (FlowableException e) {
            throw new WorkflowException("While listing available process definitions", (Throwable)e);
        }
    }

    protected ProcessDefinition getProcessDefinitionByKey(String key) {
        try {
            return (ProcessDefinition)this.engine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While accessing process " + key, (Throwable)e);
        }
    }

    protected ProcessDefinition getProcessDefinitionByDeploymentId(String deploymentId) {
        try {
            return (ProcessDefinition)this.engine.getRepositoryService().createProcessDefinitionQuery().deploymentId(deploymentId).latestVersion().singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While accessing deployment " + deploymentId, (Throwable)e);
        }
    }

    protected void exportProcessModel(String key, OutputStream os) {
        Model model = this.getModel(this.getProcessDefinitionByKey(key));
        try {
            ObjectNode modelNode = (ObjectNode)OBJECT_MAPPER.readTree(model.getMetaInfo());
            modelNode.put("modelId", model.getId());
            modelNode.replace(MODEL_DATA_JSON_MODEL, OBJECT_MAPPER.readTree(this.engine.getRepositoryService().getModelEditorSource(model.getId())));
            os.write(modelNode.toString().getBytes());
        }
        catch (IOException e) {
            LOG.error("While exporting workflow definition {}", (Object)model.getId(), (Object)e);
        }
    }

    protected void exportProcessResource(String deploymentId, String resourceName, OutputStream os) {
        try (InputStream procDefIS = this.engine.getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            IOUtils.copy((InputStream)procDefIS, (OutputStream)os);
        }
        catch (IOException e) {
            LOG.error("While exporting {}", (Object)resourceName, (Object)e);
        }
    }

    public void exportDefinition(String key, WorkflowDefinitionFormat format, OutputStream os) {
        switch (format) {
            case JSON: {
                this.exportProcessModel(key, os);
                break;
            }
            default: {
                ProcessDefinition procDef = this.getProcessDefinitionByKey(key);
                this.exportProcessResource(procDef.getDeploymentId(), procDef.getResourceName(), os);
            }
        }
    }

    public void exportDiagram(String key, OutputStream os) {
        ProcessDefinition procDef = this.getProcessDefinitionByKey(key);
        if (procDef == null) {
            throw new NotFoundException("Workflow process definition for " + key);
        }
        this.exportProcessResource(procDef.getDeploymentId(), procDef.getDiagramResourceName(), os);
    }

    public void importDefinition(String key, WorkflowDefinitionFormat format, String definition) {
        Deployment deployment;
        ProcessDefinition procDef = this.getProcessDefinitionByKey(key);
        String resourceName = procDef == null ? key + ".bpmn20.xml" : procDef.getResourceName();
        switch (format) {
            case JSON: {
                try {
                    JsonNode definitionNode = OBJECT_MAPPER.readTree(definition);
                    if (definitionNode.has(MODEL_DATA_JSON_MODEL)) {
                        definitionNode = definitionNode.get(MODEL_DATA_JSON_MODEL);
                    }
                    if (!definitionNode.has("childShapes")) {
                        throw new IllegalArgumentException("Could not find JSON node childShapes");
                    }
                    BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(definitionNode);
                    deployment = FlowableDeployUtils.deployDefinition(this.engine, resourceName, new BpmnXMLConverter().convertToXML(bpmnModel));
                    break;
                }
                catch (Exception e) {
                    throw new WorkflowException("While creating or updating process " + key, (Throwable)e);
                }
            }
            default: {
                deployment = FlowableDeployUtils.deployDefinition(this.engine, resourceName, definition.getBytes());
            }
        }
        procDef = this.getProcessDefinitionByDeploymentId(deployment.getId());
        if (!key.equals(procDef.getKey())) {
            throw new WorkflowException("Mismatching key: expected " + key + ", found " + procDef.getKey());
        }
        FlowableDeployUtils.deployModel(this.engine, procDef);
    }

    public void deleteDefinition(String key) {
        ProcessDefinition procDef = this.getProcessDefinitionByKey(key);
        if (WF_PROCESS_ID.equals(procDef.getKey())) {
            throw new WorkflowException("Cannot delete the main process userWorkflow");
        }
        try {
            this.engine.getRepositoryService().deleteDeployment(procDef.getDeploymentId());
        }
        catch (Exception e) {
            throw new WorkflowException("While deleting " + key, (Throwable)e);
        }
    }
}

