/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.configurator;

import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.DeploymentBuilder;
import org.flowable.spring.configurator.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class SingleResourceAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "single-resource";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            try {
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                    deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                } else {
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
            }
            catch (IOException e) {
                throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
            deploymentBuilder.deploy();
        }
    }
}

