/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;

public class StoreFileMover {
    private String filename = "conf/server.xml";
    private String encoding = "UTF-8";
    private String basename = System.getProperty("catalina.base");
    private File configOld;
    private File configNew;
    private File configSave;

    public File getConfigNew() {
        return this.configNew;
    }

    public File getConfigOld() {
        return this.configOld;
    }

    public File getConfigSave() {
        return this.configSave;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public StoreFileMover(String basename, String filename, String encoding) {
        this.setBasename(basename);
        this.setEncoding(encoding);
        this.setFilename(filename);
        this.init();
    }

    public StoreFileMover() {
        this.init();
    }

    public void init() {
        String configFile = this.getFilename();
        this.configOld = new File(configFile);
        if (!this.configOld.isAbsolute()) {
            this.configOld = new File(this.getBasename(), configFile);
        }
        this.configNew = new File(configFile + ".new");
        if (!this.configNew.isAbsolute()) {
            this.configNew = new File(this.getBasename(), configFile + ".new");
        }
        if (!this.configNew.getParentFile().exists() && !this.configNew.getParentFile().mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + this.configNew);
        }
        String sb = this.getTimeTag();
        this.configSave = new File(configFile + sb);
        if (!this.configSave.isAbsolute()) {
            this.configSave = new File(this.getBasename(), configFile + sb);
        }
    }

    public void move() throws IOException {
        if (this.configOld.renameTo(this.configSave)) {
            if (!this.configNew.renameTo(this.configOld)) {
                this.configSave.renameTo(this.configOld);
                throw new IOException("Cannot rename " + this.configNew.getAbsolutePath() + " to " + this.configOld.getAbsolutePath());
            }
        } else if (!this.configOld.exists()) {
            if (!this.configNew.renameTo(this.configOld)) {
                throw new IOException("Cannot move " + this.configNew.getAbsolutePath() + " to " + this.configOld.getAbsolutePath());
            }
        } else {
            throw new IOException("Cannot rename " + this.configOld.getAbsolutePath() + " to " + this.configSave.getAbsolutePath());
        }
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configNew), this.getEncoding()));
    }

    protected String getTimeTag() {
        String ts = new Timestamp(System.currentTimeMillis()).toString();
        StringBuffer sb = new StringBuffer(".");
        sb.append(ts.substring(0, 10));
        sb.append('.');
        sb.append(ts.substring(11, 13));
        sb.append('-');
        sb.append(ts.substring(14, 16));
        sb.append('-');
        sb.append(ts.substring(17, 19));
        return sb.toString();
    }
}

