/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.panels.SCIMConfPanel;
import org.apache.syncope.client.console.rest.SCIMConfRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.any.ResultPage;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtPage(label="SCIM 2.0", icon="fa-cloud", listEntitlement="SCIM_CONF_GET", priority=100)
public class SCIMConfPage
extends BaseExtPage {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMConfPage.class);
    private static final long serialVersionUID = -8156063343062111770L;
    private final SCIMConfRestClient restClient = new SCIMConfRestClient();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final WebMarkupContainer content;

    public SCIMConfPage(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build((String)"dashboard", (String)"dashboardBr", Dashboard.class)});
        this.content = new WebMarkupContainer("content");
        this.content.add(new Component[]{new Label("body", (Serializable)((Object)"General"))});
        this.content.setOutputMarkupId(true);
        this.body.add(new Component[]{this.content});
        this.updateSCIMGeneralConfContent(this.restClient.get());
    }

    private WebMarkupContainer updateSCIMGeneralConfContent(SCIMConf scimConf) {
        if (scimConf == null) {
            return this.content;
        }
        this.content.addOrReplace(new Component[]{new SCIMConfPanel("body", scimConf, this.getPageReference()){
            private static final long serialVersionUID = 8221398624379357183L;

            protected void setWindowClosedReloadCallback(BaseModal<?> modal) {
                modal.setWindowClosedCallback((ModalWindow.WindowClosedCallback & Serializable)target -> {
                    if (modal.getContent() instanceof ResultPage) {
                        Serializable result = ((ResultPage)ResultPage.class.cast(modal.getContent())).getResult();
                        try {
                            SCIMConfPage.this.restClient.set((SCIMConf)MAPPER.readValue(result.toString(), SCIMConf.class));
                            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                            modal.show(false);
                            target.add(new Component[]{SCIMConfPage.this.content});
                        }
                        catch (Exception e) {
                            LOG.error("While setting SCIM configuration", (Throwable)e);
                            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                });
            }
        }});
        return this.content;
    }
}

