/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.text.ParseException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ReportCheck;
import org.quartz.CronExpression;

public class ReportValidator
extends AbstractValidator<ReportCheck, Report> {
    public boolean isValid(Report object, ConstraintValidatorContext context) {
        Set reportletKeys;
        boolean isValid = true;
        if (object.getCronExpression() != null) {
            try {
                new CronExpression(object.getCronExpression());
            }
            catch (ParseException e) {
                LOG.error("Invalid cron expression '" + object.getCronExpression() + "'", (Throwable)e);
                isValid = false;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidReport, "Invalid cron expression")).addPropertyNode("cronExpression").addConstraintViolation();
            }
        }
        if ((reportletKeys = object.getReportlets().stream().map(Entity::getKey).collect(Collectors.toSet())).size() != object.getReportlets().size()) {
            LOG.error("Reportlet key must be unique");
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidReport, "Reportlet name must be unique")).addPropertyNode("reportletConfs").addConstraintViolation();
        }
        return isValid;
    }
}

