/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.policy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;

@Entity
@Table(name="AccountPolicy")
public class JPAAccountPolicy
extends AbstractPolicy
implements AccountPolicy,
PersistenceCapable {
    private static final long serialVersionUID = -2767606675667839060L;
    public static final String TABLE = "AccountPolicy";
    @NotNull
    private Boolean propagateSuspension = false;
    private int maxAuthenticationAttempts;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="AccountPolicyRule", joinColumns={@JoinColumn(name="policy_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")})
    private List<JPAImplementation> rules = new ArrayList<JPAImplementation>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(joinColumns={@JoinColumn(name="accountPolicy_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")})
    private Set<JPAExternalResource> resources = new HashSet<JPAExternalResource>();
    private static int pcInheritedFieldCount = AbstractPolicy.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$AbstractPolicy;
    static /* synthetic */ Class class$Ljava$lang$Boolean;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy;

    public boolean isPropagateSuspension() {
        return JPAAccountPolicy.pcGetpropagateSuspension(this);
    }

    public void setPropagateSuspension(boolean propagateSuspension) {
        JPAAccountPolicy.pcSetpropagateSuspension(this, propagateSuspension);
    }

    public int getMaxAuthenticationAttempts() {
        return JPAAccountPolicy.pcGetmaxAuthenticationAttempts(this);
    }

    public void setMaxAuthenticationAttempts(int maxAuthenticationAttempts) {
        JPAAccountPolicy.pcSetmaxAuthenticationAttempts(this, maxAuthenticationAttempts);
    }

    public boolean add(Implementation rule) {
        this.checkType(rule, JPAImplementation.class);
        this.checkImplementationType(rule, ImplementationType.ACCOUNT_RULE);
        return JPAAccountPolicy.pcGetrules(this).contains((JPAImplementation)rule) || JPAAccountPolicy.pcGetrules(this).add((JPAImplementation)rule);
    }

    public List<? extends Implementation> getRules() {
        return JPAAccountPolicy.pcGetrules(this);
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAAccountPolicy.pcGetresources(this).contains((JPAExternalResource)resource) || JPAAccountPolicy.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public Set<? extends ExternalResource> getResources() {
        return JPAAccountPolicy.pcGetresources(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1759663;
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$AbstractPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$AbstractPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$AbstractPolicy = JPAAccountPolicy.class$("org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"maxAuthenticationAttempts", "propagateSuspension", "resources", "rules"};
        Class[] classArray = new Class[4];
        classArray[0] = Integer.TYPE;
        Class clazz2 = class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JPAAccountPolicy.class$("java.lang.Boolean"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = JPAAccountPolicy.class$("java.util.Set"));
        classArray[2] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAAccountPolicy.class$("java.util.List"));
        classArray[3] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 10};
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy = JPAAccountPolicy.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAccountPolicy", (PersistenceCapable)new JPAAccountPolicy());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.maxAuthenticationAttempts = 0;
        this.propagateSuspension = null;
        this.resources = null;
        this.rules = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAccountPolicy jPAAccountPolicy = new JPAAccountPolicy();
        if (bl) {
            jPAAccountPolicy.pcClearFields();
        }
        jPAAccountPolicy.pcStateManager = stateManager;
        jPAAccountPolicy.pcCopyKeyFieldsFromObjectId(object);
        return jPAAccountPolicy;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAccountPolicy jPAAccountPolicy = new JPAAccountPolicy();
        if (bl) {
            jPAAccountPolicy.pcClearFields();
        }
        jPAAccountPolicy.pcStateManager = stateManager;
        return jPAAccountPolicy;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + AbstractPolicy.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.maxAuthenticationAttempts = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.propagateSuspension = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.resources = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.rules = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.maxAuthenticationAttempts);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.propagateSuspension);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.rules);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAAccountPolicy jPAAccountPolicy, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAccountPolicy, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.maxAuthenticationAttempts = jPAAccountPolicy.maxAuthenticationAttempts;
                return;
            }
            case 1: {
                this.propagateSuspension = jPAAccountPolicy.propagateSuspension;
                return;
            }
            case 2: {
                this.resources = jPAAccountPolicy.resources;
                return;
            }
            case 3: {
                this.rules = jPAAccountPolicy.rules;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAccountPolicy jPAAccountPolicy = (JPAAccountPolicy)object;
        if (jPAAccountPolicy.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAAccountPolicy, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy = JPAAccountPolicy.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy"));
        return clazz;
    }

    private static final int pcGetmaxAuthenticationAttempts(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.maxAuthenticationAttempts;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.maxAuthenticationAttempts;
    }

    private static final void pcSetmaxAuthenticationAttempts(JPAAccountPolicy jPAAccountPolicy, int n) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.maxAuthenticationAttempts = n;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingIntField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 0, jPAAccountPolicy.maxAuthenticationAttempts, n, 0);
    }

    private static final Boolean pcGetpropagateSuspension(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.propagateSuspension;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.propagateSuspension;
    }

    private static final void pcSetpropagateSuspension(JPAAccountPolicy jPAAccountPolicy, Boolean bl) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.propagateSuspension = bl;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 1, (Object)jPAAccountPolicy.propagateSuspension, (Object)bl, 0);
    }

    private static final Set pcGetresources(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.resources;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.resources;
    }

    private static final void pcSetresources(JPAAccountPolicy jPAAccountPolicy, Set set) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.resources = set;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 2, jPAAccountPolicy.resources, (Object)set, 0);
    }

    private static final List pcGetrules(JPAAccountPolicy jPAAccountPolicy) {
        if (jPAAccountPolicy.pcStateManager == null) {
            return jPAAccountPolicy.rules;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAccountPolicy.pcStateManager.accessingField(n);
        return jPAAccountPolicy.rules;
    }

    private static final void pcSetrules(JPAAccountPolicy jPAAccountPolicy, List list) {
        if (jPAAccountPolicy.pcStateManager == null) {
            jPAAccountPolicy.rules = list;
            return;
        }
        jPAAccountPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAAccountPolicy, pcInheritedFieldCount + 3, jPAAccountPolicy.rules, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

