/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.stereotype.Component;

@Component
public class JPAAnyUtilsFactory
implements AnyUtilsFactory {
    private final Map<AnyTypeKind, AnyUtils> instances = new HashMap<AnyTypeKind, AnyUtils>(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnyUtils getInstance(AnyTypeKind anyTypeKind) {
        AnyUtils instance;
        Map<AnyTypeKind, AnyUtils> map = this.instances;
        synchronized (map) {
            instance = this.instances.get(anyTypeKind);
            if (instance == null) {
                instance = new JPAAnyUtils(anyTypeKind);
                ApplicationContextProvider.getBeanFactory().autowireBean((Object)instance);
                this.instances.put(anyTypeKind, instance);
            }
        }
        return instance;
    }

    public AnyUtils getInstance(Any<?> any) {
        AnyTypeKind type = null;
        if (any instanceof User) {
            type = AnyTypeKind.USER;
        } else if (any instanceof Group) {
            type = AnyTypeKind.GROUP;
        } else if (any instanceof AnyObject) {
            type = AnyTypeKind.ANY_OBJECT;
        }
        if (type == null) {
            throw new IllegalArgumentException("Any type not supported: " + any.getClass().getName());
        }
        return this.getInstance(type);
    }
}

