/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAVirSchema;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.stereotype.Repository;

@Repository
public class JPAVirSchemaDAO
extends AbstractDAO<VirSchema>
implements VirSchemaDAO {
    private ExternalResourceDAO resourceDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalResourceDAO resourceDAO() {
        JPAVirSchemaDAO jPAVirSchemaDAO = this;
        synchronized (jPAVirSchemaDAO) {
            if (this.resourceDAO == null) {
                this.resourceDAO = (ExternalResourceDAO)ApplicationContextProvider.getApplicationContext().getBean(ExternalResourceDAO.class);
            }
        }
        return this.resourceDAO;
    }

    public VirSchema find(String key) {
        return (VirSchema)this.entityManager().find(JPAVirSchema.class, (Object)key);
    }

    public List<VirSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAVirSchema.class.getSimpleName()).append(" e WHERE ");
        anyTypeClasses.forEach(anyTypeClass -> queryString.append("e.anyTypeClass.id='").append(anyTypeClass.getKey()).append("' OR "));
        TypedQuery query = this.entityManager().createQuery(queryString.substring(0, queryString.length() - 4), VirSchema.class);
        return query.getResultList();
    }

    public List<VirSchema> findByProvision(Provision provision) {
        Query query = this.entityManager().createNativeQuery("SELECT t0.id FROM VirSchema t0 LEFT OUTER JOIN AnyTypeClass t1 ON t0.ANYTYPECLASS_ID = t1.id LEFT OUTER JOIN Provision t2 ON t0.PROVISION_ID = t2.id LEFT OUTER JOIN AnyType t3 ON t2.ANYTYPE_ID = t3.id LEFT OUTER JOIN Mapping t4 ON t2.id = t4.PROVISION_ID LEFT OUTER JOIN ExternalResource t5 ON t2.RESOURCE_ID = t5.id LEFT OUTER JOIN AccountPolicy t6 ON t5.ACCOUNTPOLICY_ID = t6.id LEFT OUTER JOIN ConnInstance t7 ON t5.CONNECTOR_ID = t7.id LEFT OUTER JOIN PasswordPolicy t8 ON t5.PASSWORDPOLICY_ID = t8.id LEFT OUTER JOIN PullPolicy t9 ON t5.PULLPOLICY_ID = t9.id WHERE t0.PROVISION_ID = ?1");
        query.setParameter(1, (Object)provision.getKey());
        ArrayList<VirSchema> result = new ArrayList<VirSchema>();
        for (Object key : query.getResultList()) {
            String actualKey = key instanceof Object[] ? (String)((Object[])key)[0] : (String)key;
            VirSchema virSchema = this.find(actualKey);
            if (virSchema == null) {
                LOG.error("Could not find schema with id {}, even though returned by the native query", (Object)actualKey);
                continue;
            }
            if (result.contains(virSchema)) continue;
            result.add(virSchema);
        }
        return result;
    }

    public List<VirSchema> findByKeyword(String keyword) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAVirSchema.class.getSimpleName() + " e WHERE e.id LIKE :keyword", VirSchema.class);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<VirSchema> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAVirSchema.class.getSimpleName() + " e", VirSchema.class);
        return query.getResultList();
    }

    public VirSchema save(VirSchema virSchema) {
        return (VirSchema)this.entityManager().merge((Object)virSchema);
    }

    public void delete(String key) {
        VirSchema schema = this.find(key);
        if (schema == null) {
            return;
        }
        schema.getLabels().forEach(label -> label.setSchema(null));
        this.resourceDAO().deleteMapping(key);
        if (schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getVirSchemas().remove(schema);
        }
        this.entityManager().remove((Object)schema);
    }
}

