/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAMapping;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAMappingItem;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAProvision;
import org.apache.syncope.core.provisioning.api.ConnectorRegistry;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAExternalResourceDAO
extends AbstractDAO<ExternalResource>
implements ExternalResourceDAO {
    @Autowired
    private ConnectorRegistry connRegistry;
    private TaskDAO taskDAO;
    private AnyObjectDAO anyObjectDAO;
    private UserDAO userDAO;
    private GroupDAO groupDAO;
    private PolicyDAO policyDAO;
    private VirSchemaDAO virSchemaDAO;
    private RealmDAO realmDAO;
    private ExternalResourceHistoryConfDAO externalResourceHistoryConfDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDAO taskDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.taskDAO == null) {
                this.taskDAO = (TaskDAO)ApplicationContextProvider.getApplicationContext().getBean(TaskDAO.class);
            }
        }
        return this.taskDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnyObjectDAO anyObjectDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.anyObjectDAO == null) {
                this.anyObjectDAO = (AnyObjectDAO)ApplicationContextProvider.getApplicationContext().getBean(AnyObjectDAO.class);
            }
        }
        return this.anyObjectDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDAO userDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.userDAO == null) {
                this.userDAO = (UserDAO)ApplicationContextProvider.getApplicationContext().getBean(UserDAO.class);
            }
        }
        return this.userDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupDAO groupDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.groupDAO == null) {
                this.groupDAO = (GroupDAO)ApplicationContextProvider.getApplicationContext().getBean(GroupDAO.class);
            }
        }
        return this.groupDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDAO policyDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.policyDAO == null) {
                this.policyDAO = (PolicyDAO)ApplicationContextProvider.getApplicationContext().getBean(PolicyDAO.class);
            }
        }
        return this.policyDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirSchemaDAO virSchemaDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.virSchemaDAO == null) {
                this.virSchemaDAO = (VirSchemaDAO)ApplicationContextProvider.getApplicationContext().getBean(VirSchemaDAO.class);
            }
        }
        return this.virSchemaDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealmDAO realmDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.realmDAO == null) {
                this.realmDAO = (RealmDAO)ApplicationContextProvider.getApplicationContext().getBean(RealmDAO.class);
            }
        }
        return this.realmDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalResourceHistoryConfDAO externalResourceHistoryConfDAO() {
        JPAExternalResourceDAO jPAExternalResourceDAO = this;
        synchronized (jPAExternalResourceDAO) {
            if (this.externalResourceHistoryConfDAO == null) {
                this.externalResourceHistoryConfDAO = (ExternalResourceHistoryConfDAO)ApplicationContextProvider.getApplicationContext().getBean(ExternalResourceHistoryConfDAO.class);
            }
        }
        return this.externalResourceHistoryConfDAO;
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPAExternalResource.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public ExternalResource find(String name) {
        return (ExternalResource)this.entityManager().find(JPAExternalResource.class, (Object)name);
    }

    public ExternalResource authFind(String key) {
        ExternalResource resource = this.find(key);
        if (resource == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_READ");
        if (authRealms == null || authRealms.isEmpty() || !authRealms.stream().anyMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))) {
            throw new DelegatedAdministrationException(resource.getConnector().getAdminRealm().getFullPath(), ExternalResource.class.getSimpleName(), resource.getKey());
        }
        return resource;
    }

    public List<Provision> findProvisionsByAuxClass(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAProvision.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.auxClasses", Provision.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }

    public List<MappingItem> findByTransformer(Implementation transformer) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAMappingItem.class.getSimpleName() + " e WHERE :transformer MEMBER OF e.transformers", MappingItem.class);
        query.setParameter("transformer", (Object)transformer);
        return query.getResultList();
    }

    public List<ExternalResource> findByPropagationActions(Implementation propagationActions) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAExternalResource.class.getSimpleName() + " e WHERE :propagationActions MEMBER OF e.propagationActions", ExternalResource.class);
        query.setParameter("propagationActions", (Object)propagationActions);
        return query.getResultList();
    }

    private StringBuilder getByPolicyQuery(Class<? extends Policy> policyClass) {
        StringBuilder query = new StringBuilder("SELECT e FROM ").append(JPAExternalResource.class.getSimpleName()).append(" e WHERE e.");
        if (AccountPolicy.class.isAssignableFrom(policyClass)) {
            query.append("accountPolicy");
        } else if (PasswordPolicy.class.isAssignableFrom(policyClass)) {
            query.append("passwordPolicy");
        } else if (PullPolicy.class.isAssignableFrom(policyClass)) {
            query.append("pullPolicy");
        } else if (PushPolicy.class.isAssignableFrom(policyClass)) {
            query.append("pushPolicy");
        }
        return query;
    }

    public List<ExternalResource> findByPolicy(Policy policy) {
        TypedQuery query = this.entityManager().createQuery(this.getByPolicyQuery(policy.getClass()).append("=:policy").toString(), ExternalResource.class);
        query.setParameter("policy", (Object)policy);
        return query.getResultList();
    }

    public List<ExternalResource> findAll() {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("RESOURCE_LIST");
        if (authRealms == null || authRealms.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + JPAExternalResource.class.getSimpleName() + " e", ExternalResource.class);
        return query.getResultList().stream().filter(resource -> authRealms.stream().anyMatch(realm -> resource.getConnector() != null && resource.getConnector().getAdminRealm().getFullPath().startsWith((String)realm))).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public ExternalResource save(ExternalResource resource) {
        ExternalResource merged = (ExternalResource)this.entityManager().merge((Object)resource);
        try {
            this.connRegistry.registerConnector(merged);
        }
        catch (NotFoundException e) {
            LOG.error("While registering connector for resource", (Throwable)e);
        }
        return merged;
    }

    public void deleteMapping(String intAttrName) {
        TypedQuery query = this.entityManager().createQuery("SELECT m FROM " + JPAMappingItem.class.getSimpleName() + " m WHERE m.intAttrName=:intAttrName", MappingItem.class);
        query.setParameter("intAttrName", (Object)intAttrName);
        HashSet itemKeys = new HashSet();
        query.getResultList().forEach(item -> itemKeys.add(item.getKey()));
        itemKeys.stream().map(itemKey -> (JPAMappingItem)this.entityManager().find(JPAMappingItem.class, itemKey)).filter(item -> item != null).map(item -> {
            item.getMapping().getItems().remove(item);
            return item;
        }).map(item -> {
            item.setMapping(null);
            return item;
        }).forEachOrdered(item -> this.entityManager().remove(item));
        this.entityManager().getEntityManagerFactory().getCache().evict(JPAMappingItem.class);
        this.entityManager().getEntityManagerFactory().getCache().evict(JPAMapping.class);
    }

    public void delete(String name) {
        ExternalResource resource = this.find(name);
        if (resource == null) {
            return;
        }
        this.taskDAO().deleteAll(resource, TaskType.PROPAGATION);
        this.taskDAO().deleteAll(resource, TaskType.PULL);
        this.taskDAO().deleteAll(resource, TaskType.PUSH);
        this.realmDAO().findByResource(resource).forEach(realm -> realm.getResources().remove(resource));
        this.anyObjectDAO().findByResource(resource).forEach(anyObject -> anyObject.getResources().remove(resource));
        this.userDAO().findByResource(resource).forEach(user -> user.getResources().remove(resource));
        this.groupDAO().findByResource(resource).forEach(group -> group.getResources().remove(resource));
        this.policyDAO().findByResource(resource).forEach(policy -> policy.getResources().remove(resource));
        resource.getProvisions().stream().peek(provision -> {
            provision.setUidOnCreate(null);
            if (provision.getMapping() != null) {
                provision.getMapping().getItems().forEach(item -> item.setMapping(null));
                provision.getMapping().getItems().clear();
            }
            provision.setMapping(null);
            provision.setResource(null);
        }).forEach(provision -> this.virSchemaDAO().findByProvision(provision).forEach(schema -> this.virSchemaDAO().delete(schema.getKey())));
        this.externalResourceHistoryConfDAO().deleteByEntity(resource);
        if (resource.getConnector() != null && resource.getConnector().getResources() != null && !resource.getConnector().getResources().isEmpty()) {
            resource.getConnector().getResources().remove(resource);
        }
        resource.setConnector(null);
        this.entityManager().remove((Object)resource);
    }
}

