/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.policy.DefaultPullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRuleConfClass;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;

@PullCorrelationRuleConfClass(value=DefaultPullCorrelationRuleConf.class)
public class DefaultPullCorrelationRule
implements PullCorrelationRule {
    private DefaultPullCorrelationRuleConf conf;

    public void setConf(PullCorrelationRuleConf conf) {
        if (!(conf instanceof DefaultPullCorrelationRuleConf)) {
            throw new IllegalArgumentException(DefaultPullCorrelationRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultPullCorrelationRuleConf)DefaultPullCorrelationRuleConf.class.cast(conf);
    }

    public SearchCond getSearchCond(ConnectorObject connObj, Provision provision) {
        Map mappingItems = provision.getMapping().getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Function.identity()));
        ArrayList searchConds = new ArrayList();
        this.conf.getSchemas().forEach(schema -> {
            AttributeCond.Type type;
            Attribute attr;
            Item item = (Item)mappingItems.get(schema);
            Attribute attribute = attr = item == null ? null : connObj.getAttributeByName(item.getExtAttrName());
            if (attr == null) {
                throw new IllegalArgumentException("Connector object does not contains the attributes to perform the search: " + schema);
            }
            String expression = null;
            if (attr.getValue() == null || attr.getValue().isEmpty() || attr.getValue().size() == 1 && attr.getValue().get(0) == null) {
                type = AttributeCond.Type.ISNULL;
            } else {
                type = AttributeCond.Type.EQ;
                expression = attr.getValue().size() > 1 ? attr.getValue().toString() : attr.getValue().get(0).toString();
            }
            AnyCond cond = "key".equalsIgnoreCase((String)schema) || "username".equalsIgnoreCase((String)schema) || "name".equalsIgnoreCase((String)schema) ? new AnyCond() : new AttributeCond();
            cond.setSchema(schema);
            cond.setType(type);
            cond.setExpression(expression);
            searchConds.add(SearchCond.getLeafCond((AttributeCond)cond));
        });
        return this.conf.isOrSchemas() ? SearchCond.getOrCond(searchConds) : SearchCond.getAndCond(searchConds);
    }
}

