/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.syncope.core.persistence.api.content.ContentLoader;
import org.apache.syncope.core.persistence.jpa.content.AbstractContentDealer;
import org.apache.syncope.core.persistence.jpa.content.ContentLoaderHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ResourceWithFallbackLoader;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class XMLContentLoader
extends AbstractContentDealer
implements ContentLoader {
    @Resource(name="viewsXML")
    private ResourceWithFallbackLoader viewsXML;
    @Resource(name="indexesXML")
    private ResourceWithFallbackLoader indexesXML;

    public Integer getPriority() {
        return 0;
    }

    public void load() {
        this.domainsHolder.getDomains().forEach((domain, datasource) -> {
            boolean existingData;
            EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)domain).createEntityManager();
            JdbcTemplate jdbcTemplate = new JdbcTemplate(datasource);
            try {
                existingData = (Integer)jdbcTemplate.queryForObject("SELECT COUNT(0) FROM SyncopeConf", Integer.class) > 0;
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not access to table SyncopeConf", domain, (Object)e);
                existingData = true;
            }
            if (existingData) {
                LOG.info("[{}] Data found in the database, leaving untouched", domain);
            } else {
                LOG.info("[{}] Empty database found, loading default content", domain);
                try {
                    this.createViews((String)domain, (DataSource)datasource);
                }
                catch (IOException e) {
                    LOG.error("[{}] While creating views", domain, (Object)e);
                }
                try {
                    this.createIndexes((String)domain, (DataSource)datasource);
                }
                catch (IOException e) {
                    LOG.error("[{}] While creating indexes", domain, (Object)e);
                }
                try {
                    ResourceWithFallbackLoader contentXML = (ResourceWithFallbackLoader)ApplicationContextProvider.getBeanFactory().getBean(domain + "ContentXML", ResourceWithFallbackLoader.class);
                    this.loadDefaultContent((String)domain, contentXML, (DataSource)datasource);
                }
                catch (Exception e) {
                    LOG.error("[{}] While loading default content", domain, (Object)e);
                }
            }
        });
    }

    private void loadDefaultContent(String domain, ResourceWithFallbackLoader contentXML, DataSource dataSource) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try (InputStream in = contentXML.getResource().getInputStream();){
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)new ContentLoaderHandler(dataSource, "dataset", true));
            LOG.debug("[{}] Default content successfully loaded", (Object)domain);
        }
    }

    private void createViews(String domain, DataSource dataSource) throws IOException {
        LOG.debug("[{}] Creating views", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        Properties views = PropertiesLoaderUtils.loadProperties((org.springframework.core.io.Resource)this.viewsXML.getResource());
        views.stringPropertyNames().stream().sorted().forEachOrdered(idx -> {
            LOG.debug("[{}] Creating view {}", (Object)domain, (Object)views.get(idx).toString());
            try {
                jdbcTemplate.execute(views.get(idx).toString().replaceAll("\\n", " "));
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create view", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Views created");
    }

    private void createIndexes(String domain, DataSource dataSource) throws IOException {
        LOG.debug("[{}] Creating indexes", (Object)domain);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        Properties indexes = PropertiesLoaderUtils.loadProperties((org.springframework.core.io.Resource)this.indexesXML.getResource());
        indexes.stringPropertyNames().stream().sorted().forEachOrdered(idx -> {
            LOG.debug("[{}] Creating index {}", (Object)domain, (Object)indexes.get(idx).toString());
            try {
                jdbcTemplate.execute(indexes.get(idx).toString());
            }
            catch (DataAccessException e) {
                LOG.error("[{}] Could not create index", (Object)domain, (Object)e);
            }
        });
        LOG.debug("Indexes created");
    }
}

