/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentLoaderHandler
extends DefaultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLoaderHandler.class);
    private final JdbcTemplate jdbcTemplate;
    private final String rootElement;
    private final boolean continueOnError;

    public ContentLoaderHandler(DataSource dataSource, String rootElement, boolean continueOnError) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.rootElement = rootElement;
        this.continueOnError = continueOnError;
    }

    private Object[] getParameters(String tableName, Attributes attrs) {
        Map colTypes = (Map)this.jdbcTemplate.query("SELECT * FROM " + tableName + " WHERE 0=1", rs -> {
            HashMap<String, Integer> colTypes1 = new HashMap<String, Integer>();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                colTypes1.put(rs.getMetaData().getColumnName(i).toUpperCase(), rs.getMetaData().getColumnType(i));
            }
            return colTypes1;
        });
        Object[] parameters = new Object[attrs.getLength()];
        block25: for (int i = 0; i < attrs.getLength(); ++i) {
            Integer colType = (Integer)colTypes.get(attrs.getQName(i).toUpperCase());
            if (colType == null) {
                LOG.warn("No column type found for {}", (Object)attrs.getQName(i).toUpperCase());
                colType = 12;
            }
            switch (colType) {
                case -6: 
                case 4: 
                case 5: {
                    try {
                        parameters[i] = Integer.valueOf(attrs.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Integer '{}'", (Object)attrs.getValue(i));
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case -5: 
                case 2: 
                case 3: {
                    try {
                        parameters[i] = Long.valueOf(attrs.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Long '{}'", (Object)attrs.getValue(i));
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case 8: {
                    try {
                        parameters[i] = Double.valueOf(attrs.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Double '{}'", (Object)attrs.getValue(i));
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case 6: 
                case 7: {
                    try {
                        parameters[i] = Float.valueOf(attrs.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Float '{}'", (Object)attrs.getValue(i));
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case 91: 
                case 92: 
                case 93: {
                    try {
                        parameters[i] = FormatUtils.parseDate((String)attrs.getValue(i));
                    }
                    catch (ParseException e) {
                        LOG.error("Unparsable Date '{}'", (Object)attrs.getValue(i));
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case -7: 
                case 16: {
                    parameters[i] = "1".equals(attrs.getValue(i)) ? Boolean.TRUE : Boolean.FALSE;
                    continue block25;
                }
                case -4: 
                case -3: 
                case -2: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)attrs.getValue(i));
                    }
                    catch (IllegalArgumentException e) {
                        parameters[i] = attrs.getValue(i);
                    }
                    continue block25;
                }
                case 2004: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)attrs.getValue(i));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Error decoding hex string to specify a blob parameter", (Throwable)e);
                        parameters[i] = attrs.getValue(i);
                    }
                    catch (Exception e) {
                        LOG.warn("Error creating a new blob parameter", (Throwable)e);
                    }
                    continue block25;
                }
                default: {
                    parameters[i] = attrs.getValue(i);
                }
            }
        }
        return parameters;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block4: {
            if (this.rootElement.equals(qName)) {
                return;
            }
            StringBuilder query = new StringBuilder("INSERT INTO ").append(qName).append('(');
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < atts.getLength(); ++i) {
                query.append(atts.getQName(i));
                values.append('?');
                if (i >= atts.getLength() - 1) continue;
                query.append(',');
                values.append(',');
            }
            query.append(") VALUES (").append((CharSequence)values).append(')');
            try {
                this.jdbcTemplate.update(query.toString(), this.getParameters(qName, atts));
            }
            catch (DataAccessException e) {
                LOG.error("While trying to perform {} with params {}", new Object[]{query, this.getParameters(qName, atts), e});
                if (this.continueOnError) break block4;
                throw e;
            }
        }
    }
}

