/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.syncope.common.lib.to.WorkflowDefinitionTO;
import org.apache.syncope.common.rest.api.service.WorkflowService;
import org.apache.syncope.core.logic.WorkflowLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.apache.syncope.core.workflow.api.WorkflowDefinitionFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowServiceImpl
extends AbstractServiceImpl
implements WorkflowService {
    @Autowired
    private WorkflowLogic logic;

    public List<WorkflowDefinitionTO> list(String anyType) {
        return this.logic.list(anyType);
    }

    public Response get(String anyType, String key) {
        WorkflowDefinitionFormat format = this.messageContext.getHttpHeaders().getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE) ? WorkflowDefinitionFormat.JSON : WorkflowDefinitionFormat.XML;
        StreamingOutput sout = os -> this.logic.exportDefinition(anyType, key, format, os);
        return Response.ok((Object)sout).type(format == WorkflowDefinitionFormat.JSON ? MediaType.APPLICATION_JSON_TYPE : MediaType.APPLICATION_XHTML_XML_TYPE).build();
    }

    public Response exportDiagram(String anyType, String key) {
        StreamingOutput sout = os -> this.logic.exportDiagram(anyType, key, os);
        return Response.ok((Object)sout).type("image/png").build();
    }

    public void set(String anyType, String key, String definition) {
        WorkflowDefinitionFormat format = this.messageContext.getHttpHeaders().getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? WorkflowDefinitionFormat.JSON : WorkflowDefinitionFormat.XML;
        this.logic.importDefinition(anyType, key, format, definition);
    }

    public void delete(String anyType, String key) {
        this.logic.delete(anyType, key);
    }
}

