/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.rest.api.service.ConnectorService;
import org.apache.syncope.core.logic.ConnectorLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectorServiceImpl
extends AbstractServiceImpl
implements ConnectorService {
    @Autowired
    private ConnectorLogic logic;

    public Response create(ConnInstanceTO connInstanceTO) {
        ConnInstanceTO connInstance = this.logic.create(connInstanceTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(connInstance.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)connInstance.getKey()).build();
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public List<ConnBundleTO> getBundles(String lang) {
        return this.logic.getBundles(lang);
    }

    public List<ConnIdObjectClassTO> buildObjectClassInfo(ConnInstanceTO connInstanceTO, boolean includeSpecial) {
        return this.logic.buildObjectClassInfo(connInstanceTO, includeSpecial);
    }

    public List<ConnInstanceTO> list(String lang) {
        return this.logic.list(lang);
    }

    public ConnInstanceTO read(String key, String lang) {
        return this.logic.read(key, lang);
    }

    public ConnInstanceTO readByResource(String resourceName, String lang) {
        return this.logic.readByResource(resourceName, lang);
    }

    public void update(ConnInstanceTO connInstanceTO) {
        this.logic.update(connInstanceTO);
    }

    public void check(ConnInstanceTO connInstanceTO) {
        this.logic.check(connInstanceTO);
    }

    public void reload() {
        this.logic.reload();
    }
}

