/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AssociationPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.DeassociationPatch;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;

public abstract class AbstractAnyService<TO extends AnyTO, P extends AnyPatch>
extends AbstractServiceImpl
implements AnyService<TO> {
    protected abstract AnyDAO<?> getAnyDAO();

    protected abstract AbstractAnyLogic<TO, P> getAnyLogic();

    protected abstract P newPatch(String var1);

    public Set<AttrTO> read(String key, SchemaType schemaType) {
        Set result;
        TO any = this.read(key);
        switch (schemaType) {
            case DERIVED: {
                result = any.getDerAttrs();
                break;
            }
            case VIRTUAL: {
                result = any.getVirAttrs();
                break;
            }
            default: {
                result = any.getPlainAttrs();
            }
        }
        return result;
    }

    public AttrTO read(String key, SchemaType schemaType, String schema) {
        Optional result;
        TO any = this.read(key);
        switch (schemaType) {
            case DERIVED: {
                result = any.getDerAttr(schema);
                break;
            }
            case VIRTUAL: {
                result = any.getVirAttr(schema);
                break;
            }
            default: {
                result = any.getPlainAttr(schema);
            }
        }
        if (!result.isPresent()) {
            throw new NotFoundException("Attribute for type " + schemaType + " and schema " + schema);
        }
        return (AttrTO)result.get();
    }

    public TO read(String key) {
        return (TO)this.getAnyLogic().read(this.getActualKey(this.getAnyDAO(), key));
    }

    public PagedResult<TO> search(AnyQuery anyQuery) {
        String realm = StringUtils.prependIfMissing((String)anyQuery.getRealm(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        boolean isAssignableCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? false : -1 != anyQuery.getFiql().indexOf(SpecialAttr.ASSIGNABLE.toString());
        SearchCond searchCond = StringUtils.isBlank((CharSequence)anyQuery.getFiql()) ? null : this.getSearchCond(anyQuery.getFiql(), realm);
        Pair result = this.getAnyLogic().search(searchCond, anyQuery.getPage().intValue(), anyQuery.getSize().intValue(), this.getOrderByClauses(anyQuery.getOrderBy()), isAssignableCond ? "/" : realm, anyQuery.getDetails().booleanValue());
        return this.buildPagedResult((List)result.getRight(), anyQuery.getPage(), anyQuery.getSize(), (Integer)result.getLeft());
    }

    protected Date findLastChange(String key) {
        Date lastChange = this.getAnyDAO().findLastChange(key);
        if (lastChange == null) {
            throw new NotFoundException("User, Group or Any Object for " + key);
        }
        return lastChange;
    }

    protected Response doUpdate(P anyPatch) {
        anyPatch.setKey(this.getActualKey(this.getAnyDAO(), anyPatch.getKey()));
        Date etagDate = this.findLastChange(anyPatch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        ProvisioningResult updated = this.getAnyLogic().update(anyPatch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    private void addUpdateOrReplaceAttr(String key, SchemaType schemaType, AttrTO attrTO, PatchOperation operation) {
        if (attrTO.getSchema() == null) {
            throw new NotFoundException("Must specify schema");
        }
        P patch = this.newPatch(key);
        switch (schemaType) {
            case VIRTUAL: {
                patch.getVirAttrs().add(attrTO);
                break;
            }
            case PLAIN: {
                patch.getPlainAttrs().add(((AttrPatch.Builder)new AttrPatch.Builder().operation(operation)).attrTO(attrTO).build());
                break;
            }
        }
        this.doUpdate(patch);
    }

    public Response update(String key, SchemaType schemaType, AttrTO attrTO) {
        String actualKey = this.getActualKey(this.getAnyDAO(), key);
        this.addUpdateOrReplaceAttr(actualKey, schemaType, attrTO, PatchOperation.ADD_REPLACE);
        return this.modificationResponse(this.read(actualKey, schemaType, attrTO.getSchema()));
    }

    public void delete(String key, SchemaType schemaType, String schema) {
        this.addUpdateOrReplaceAttr(this.getActualKey(this.getAnyDAO(), key), schemaType, new AttrTO.Builder().schema(schema).build(), PatchOperation.DELETE);
    }

    public Response delete(String key) {
        String actualKey = this.getActualKey(this.getAnyDAO(), key);
        Date etagDate = this.findLastChange(actualKey);
        this.checkETag(String.valueOf(etagDate.getTime()));
        ProvisioningResult deleted = this.getAnyLogic().delete(actualKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }

    public Response deassociate(DeassociationPatch patch) {
        ProvisioningResult updated;
        Date etagDate = this.findLastChange(patch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        switch (patch.getAction()) {
            case UNLINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().unlink(patch.getKey(), (Collection)patch.getResources()));
                break;
            }
            case UNASSIGN: {
                updated = this.getAnyLogic().unassign(patch.getKey(), (Collection)patch.getResources(), this.isNullPriorityAsync());
                break;
            }
            case DEPROVISION: {
                updated = this.getAnyLogic().deprovision(patch.getKey(), (Collection)patch.getResources(), this.isNullPriorityAsync());
                break;
            }
            default: {
                throw new BadRequestException("Missing action");
            }
        }
        List batchResponseItems = patch.getAction() == ResourceDeassociationAction.UNLINK ? patch.getResources().stream().map(resource -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", Arrays.asList(resource));
            item.setStatus(((AnyTO)updated.getEntity()).getResources().contains(resource) ? Response.Status.BAD_REQUEST.getStatusCode() : Response.Status.OK.getStatusCode());
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", Arrays.asList(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).collect(Collectors.toList()) : updated.getPropagationStatuses().stream().map(status -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", Arrays.asList(status.getResource()));
            item.setStatus(status.getStatus().getHttpStatus());
            if (status.getFailureReason() != null) {
                item.getHeaders().put("X-Application-Error-Info", Arrays.asList(status.getFailureReason()));
            }
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", Arrays.asList(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).collect(Collectors.toList());
        String boundary = "deassociate_" + GENERATOR.generate().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate(batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }

    public Response associate(AssociationPatch patch) {
        ProvisioningResult updated;
        Date etagDate = this.findLastChange(patch.getKey());
        this.checkETag(String.valueOf(etagDate.getTime()));
        switch (patch.getAction()) {
            case LINK: {
                updated = new ProvisioningResult();
                updated.setEntity((EntityTO)this.getAnyLogic().link(patch.getKey(), (Collection)patch.getResources()));
                break;
            }
            case ASSIGN: {
                updated = this.getAnyLogic().assign(patch.getKey(), (Collection)patch.getResources(), patch.getValue() != null, (String)patch.getValue(), this.isNullPriorityAsync());
                break;
            }
            case PROVISION: {
                updated = this.getAnyLogic().provision(patch.getKey(), (Collection)patch.getResources(), patch.getValue() != null, (String)patch.getValue(), this.isNullPriorityAsync());
                break;
            }
            default: {
                throw new BadRequestException("Missing action");
            }
        }
        List batchResponseItems = patch.getAction() == ResourceAssociationAction.LINK ? patch.getResources().stream().map(resource -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", Arrays.asList(resource));
            item.setStatus(((AnyTO)updated.getEntity()).getResources().contains(resource) ? Response.Status.OK.getStatusCode() : Response.Status.BAD_REQUEST.getStatusCode());
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", Arrays.asList(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).collect(Collectors.toList()) : updated.getPropagationStatuses().stream().map(status -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", Arrays.asList(status.getResource()));
            item.setStatus(status.getStatus().getHttpStatus());
            if (status.getFailureReason() != null) {
                item.getHeaders().put("X-Application-Error-Info", Arrays.asList(status.getFailureReason()));
            }
            if (this.getPreference() == Preference.RETURN_NO_CONTENT) {
                item.getHeaders().put("Preference-Applied", Arrays.asList(Preference.RETURN_NO_CONTENT.toString()));
            } else {
                item.setContent(POJOHelper.serialize((Object)updated.getEntity()));
            }
            return item;
        }).collect(Collectors.toList());
        String boundary = "associate_" + GENERATOR.generate().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate(batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }
}

