/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;

public class BatchItemRequest
extends HttpServletRequestWrapper {
    private final String basePath;
    private final BatchRequestItem batchItem;
    private final ServletInputStream inputStream;

    public BatchItemRequest(String basePath, HttpServletRequest request, final BatchRequestItem batchItem) {
        super(request);
        this.basePath = basePath;
        this.batchItem = batchItem;
        this.inputStream = new ServletInputStream(){
            private final ByteArrayInputStream bais;
            private boolean isFinished;
            private boolean isReady;
            {
                this.bais = new ByteArrayInputStream(batchItem.getContent().getBytes());
                this.isFinished = false;
                this.isReady = true;
            }

            public boolean isFinished() {
                return this.isFinished;
            }

            public boolean isReady() {
                return this.isReady;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                this.isFinished = true;
                this.isReady = false;
                return this.bais.read();
            }
        };
    }

    public String getMethod() {
        return this.batchItem.getMethod();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.basePath).append(this.getRequestURI());
    }

    public String getRequestURI() {
        return this.batchItem.getRequestURI();
    }

    public String getQueryString() {
        return this.batchItem.getQueryString();
    }

    public String getContentType() {
        return this.batchItem.getHeaders().containsKey("Content-Type") ? ((List)this.batchItem.getHeaders().get("Content-Type")).get(0).toString() : "*/*";
    }

    public int getContentLength() {
        return this.batchItem.getHeaders().containsKey("Content-Length") ? Integer.valueOf(((List)this.batchItem.getHeaders().get("Content-Length")).get(0).toString()) : 0;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getHeader(String name) {
        return this.batchItem.getHeaders().containsKey(name) ? ((List)this.batchItem.getHeaders().get(name)).get(0).toString() : ("Content-Type".equals(name) || "Accept".equals(name) ? "*/*" : super.getHeader(name));
    }

    public Enumeration<String> getHeaders(String name) {
        return this.batchItem.getHeaders().containsKey(name) ? Collections.enumeration(((List)this.batchItem.getHeaders().get(name)).stream().map(Object::toString).collect(Collectors.toList())) : ("Content-Type".equals(name) || "Accept".equals(name) ? Collections.enumeration(Arrays.asList("*/*")) : super.getHeaders(name));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }
}

