/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.pipeline.CachingPipeline;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.sax.SAXPipelineComponent;
import org.apache.cocoon.sax.component.XMLGenerator;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.cocoon.sax.component.XSLTTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.core.rest.cxf.WadlGenerator;
import org.apache.syncope.core.spring.ApplicationContextProvider;

public class WADLServlet
extends HttpServlet {
    private static final long serialVersionUID = -6737005675471095560L;
    private static final Pattern SCHEMA_PATTERN = Pattern.compile("/schema_(.*)_(.*)\\.html");

    protected void finish(Pipeline<SAXPipelineComponent> pipeline, HttpServletResponse response) throws ServletException, IOException {
        pipeline.addComponent((PipelineComponent)XMLSerializer.createHTML4Serializer());
        pipeline.setup((OutputStream)response.getOutputStream());
        try {
            pipeline.execute();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block29: {
            Matcher schemaMatcher = SCHEMA_PATTERN.matcher(request.getServletPath());
            WadlGenerator wadlGenerator = (WadlGenerator)((Object)ApplicationContextProvider.getApplicationContext().getBean(WadlGenerator.class));
            String wadl = wadlGenerator.getWadl();
            CachingPipeline pipeline = new CachingPipeline();
            pipeline.addComponent((PipelineComponent)new XMLGenerator(wadl));
            if ("/index.html".equals(request.getServletPath())) {
                XSLTTransformer xslt = new XSLTTransformer(((Object)((Object)this)).getClass().getResource("/wadl2html/index.xsl"));
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("contextPath", request.getContextPath());
                xslt.setParameters(parameters);
                pipeline.addComponent((PipelineComponent)xslt);
                this.finish((Pipeline<SAXPipelineComponent>)pipeline, response);
            } else if (schemaMatcher.matches()) {
                XSLTTransformer xslt = new XSLTTransformer(((Object)((Object)this)).getClass().getResource("/wadl2html/schema.xsl"));
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("contextPath", request.getContextPath());
                parameters.put("schema-position", schemaMatcher.group(1));
                parameters.put("schema-prefix", schemaMatcher.group(2));
                xslt.setParameters(parameters);
                pipeline.addComponent((PipelineComponent)xslt);
                this.finish((Pipeline<SAXPipelineComponent>)pipeline, response);
            } else {
                if ("/syncope.wadl".equals(request.getServletPath())) {
                    response.setContentType("application/xml");
                    try (ByteArrayInputStream in = new ByteArrayInputStream(wadl.getBytes());
                         ServletOutputStream out = response.getOutputStream();){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        break block29;
                    }
                }
                throw new ServerException("URL not supported: " + request.getRequestURI());
            }
        }
    }
}

