/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.rest.cxf.JavaDocUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;

public class SyncopeOpenApiCustomizer
extends OpenApiCustomizer {
    private List<String> domains;

    public SyncopeOpenApiCustomizer() {
        URL[] javaDocURLs = JavaDocUtils.getJavaDocURLs();
        if (javaDocURLs != null) {
            super.setJavaDocURLs(javaDocURLs);
        }
    }

    public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
        LinkedHashMap<String, Header> headers = new LinkedHashMap<String, Header>();
        headers.put("X-Application-Error-Code", new Header().schema(new Schema().type("string")).description("Error code"));
        headers.put("X-Application-Error-Info", new Header().schema(new Schema().type("string")).description("Error message"));
        Content content = new Content();
        content.addMediaType("application/json", new MediaType().schema(new Schema()));
        content.addMediaType("application/xml", new MediaType().schema(new Schema()));
        configuration.getOpenAPI().getComponents().addResponses("400", new ApiResponse().description("An error occurred; HTTP status code can vary depending on the actual error: 400, 403, 404, 409, 412").headers(headers).content(content));
        return super.customize(configuration);
    }

    protected void addParameters(List<Parameter> parameters) {
        Optional<Parameter> domainHeaderParameter;
        if (this.domains == null) {
            this.domains = new ArrayList(((DomainsHolder)ApplicationContextProvider.getApplicationContext().getBean(DomainsHolder.class)).getDomains().keySet());
        }
        if (!(domainHeaderParameter = parameters.stream().filter(parameter -> parameter instanceof HeaderParameter && "X-Syncope-Domain".equals(parameter.getName())).findFirst()).isPresent()) {
            HeaderParameter parameter2 = new HeaderParameter();
            parameter2.setName("X-Syncope-Domain");
            parameter2.setRequired(Boolean.valueOf(true));
            Schema schema = new Schema();
            schema.setType("string");
            schema.setEnum(this.domains);
            schema.setDefault((Object)"Master");
            parameter2.setSchema(schema);
            parameters.add((Parameter)parameter2);
        }
    }
}

