/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.engine.test.profiler.ProfileSession;
import org.flowable.engine.test.profiler.ProfilingDbSqlSessionFactory;
import org.flowable.engine.test.profiler.TotalExecutionTimeCommandInterceptor;

public class FlowableProfiler
implements EngineConfigurator {
    protected static FlowableProfiler INSTANCE = new FlowableProfiler();
    protected ProfileSession currentProfileSession;
    protected List<ProfileSession> profileSessions = new ArrayList<ProfileSession>();

    public static FlowableProfiler getInstance() {
        return INSTANCE;
    }

    public void beforeInit(AbstractEngineConfiguration engineConfiguration) {
        ArrayList<TotalExecutionTimeCommandInterceptor> interceptors = new ArrayList<TotalExecutionTimeCommandInterceptor>();
        interceptors.add(new TotalExecutionTimeCommandInterceptor());
        engineConfiguration.setCustomPreCommandInterceptors(interceptors);
        engineConfiguration.setDbSqlSessionFactory((DbSqlSessionFactory)new ProfilingDbSqlSessionFactory());
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
    }

    public int getPriority() {
        return 0;
    }

    public void reset() {
        if (this.currentProfileSession != null) {
            this.stopCurrentProfileSession();
        }
        this.currentProfileSession = null;
        this.profileSessions.clear();
    }

    public void startProfileSession(String name) {
        this.currentProfileSession = new ProfileSession(name);
        this.profileSessions.add(this.currentProfileSession);
    }

    public void stopCurrentProfileSession() {
        this.currentProfileSession.setEndTime(new Date());
        this.currentProfileSession = null;
    }

    public ProfileSession getCurrentProfileSession() {
        return this.currentProfileSession;
    }

    public void setCurrentProfileSession(ProfileSession currentProfileSession) {
        this.currentProfileSession = currentProfileSession;
    }

    public List<ProfileSession> getProfileSessions() {
        return this.profileSessions;
    }

    public void setProfileSessions(List<ProfileSession> profileSessions) {
        this.profileSessions = profileSessions;
    }
}

