/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveProcessDefinitionCmd;
import org.flowable.engine.impl.form.FormHandlerHelper;
import org.flowable.engine.impl.form.StartFormHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;

public class SubmitStartFormCmd
extends NeedsActiveProcessDefinitionCmd<ProcessInstance> {
    private static final long serialVersionUID = 1L;
    protected final String businessKey;
    protected Map<String, String> properties;

    public SubmitStartFormCmd(String processDefinitionId, String businessKey, Map<String, String> properties) {
        super(processDefinitionId);
        this.businessKey = businessKey;
        this.properties = properties;
    }

    @Override
    protected ProcessInstance execute(CommandContext commandContext, ProcessDefinitionEntity processDefinition) {
        if (Flowable5Util.isFlowable5ProcessDefinition((ProcessDefinition)processDefinition, commandContext)) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.submitStartFormData(processDefinition.getId(), this.businessKey, this.properties);
        }
        ExecutionEntity processInstance = null;
        ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
        processInstance = this.businessKey != null ? (ExecutionEntity)processInstanceHelper.createProcessInstance(processDefinition, this.businessKey, null, null, null) : (ExecutionEntity)processInstanceHelper.createProcessInstance(processDefinition, null, null, null, null);
        CommandContextUtil.getHistoryManager(commandContext).recordFormPropertiesSubmitted(processInstance.getExecutions().get(0), this.properties, null);
        FormHandlerHelper formHandlerHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getFormHandlerHelper();
        StartFormHandler startFormHandler = formHandlerHelper.getStartFormHandler(commandContext, processDefinition);
        startFormHandler.submitFormProperties(this.properties, processInstance);
        processInstanceHelper.startProcessInstance(processInstance, commandContext, this.convertPropertiesToVariablesMap());
        return processInstance;
    }

    protected Map<String, Object> convertPropertiesToVariablesMap() {
        HashMap<String, Object> vars = new HashMap<String, Object>(this.properties.size());
        for (String key : this.properties.keySet()) {
            vars.put(key, this.properties.get(key));
        }
        return vars;
    }
}

