/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;

public class StartProcessInstanceWithFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected String processInstanceName;

    public StartProcessInstanceWithFormCmd(String processDefinitionId, String outcome, Map<String, Object> variables, String processInstanceName) {
        this.processDefinitionId = processDefinitionId;
        this.outcome = outcome;
        this.variables = variables;
        this.processInstanceName = processInstanceName;
    }

    public ProcessInstance execute(CommandContext commandContext) {
        FormRepositoryService formRepositoryService;
        StartEvent startEvent;
        BpmnModel bpmnModel;
        Process process;
        FlowElement startElement;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        DeploymentManager deploymentCache = processEngineConfiguration.getDeploymentManager();
        ProcessDefinition processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        FormInfo formInfo = null;
        Map formVariables = null;
        FormService formService = CommandContextUtil.getFormService();
        if ((this.variables != null || this.outcome != null) && (startElement = (process = (bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId())).getProcessById(processDefinition.getKey())).getInitialFlowElement()) instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey()) && (formInfo = (formRepositoryService = CommandContextUtil.getFormRepositoryService()).getFormModelByKey(startEvent.getFormKey())) != null) {
            formVariables = formService.getVariablesFromFormSubmission(formInfo, this.variables, this.outcome);
        }
        ProcessInstance processInstance = this.createAndStartProcessInstance(processDefinition, this.processInstanceName, formVariables, commandContext);
        if (formInfo != null) {
            formService.createFormInstance(formVariables, formInfo, null, processInstance.getId(), processInstance.getProcessDefinitionId());
            FormFieldHandler formFieldHandler = CommandContextUtil.getProcessEngineConfiguration(commandContext).getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, processInstance.getId(), null, null, this.variables);
        }
        return processInstance;
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String processInstanceName, Map<String, Object> variables, CommandContext commandContext) {
        ProcessInstanceHelper processInstanceHelper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceHelper();
        return processInstanceHelper.createAndStartProcessInstance(processDefinition, null, processInstanceName, variables, null);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

