/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg.multitenant;

import javax.sql.DataSource;
import org.flowable.common.engine.impl.cfg.multitenant.TenantAwareDataSource;
import org.flowable.common.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.impl.SchemaOperationProcessEngineClose;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cfg.multitenant.ExecuteSchemaOperationCommand;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.asyncexecutor.multitenant.ExecutorPerTenantAsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSchemaMultiTenantProcessEngineConfiguration
extends ProcessEngineConfigurationImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiSchemaMultiTenantProcessEngineConfiguration.class);
    protected TenantInfoHolder tenantInfoHolder;
    protected boolean booted;

    public MultiSchemaMultiTenantProcessEngineConfiguration(TenantInfoHolder tenantInfoHolder) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.taskIdGenerator = this.idGenerator = new StrongUuidGenerator();
        this.dataSource = new TenantAwareDataSource(tenantInfoHolder);
    }

    public void registerTenant(String tenantId, DataSource dataSource) {
        ((TenantAwareDataSource)super.getDataSource()).addDataSource((Object)tenantId, dataSource);
        if (this.booted) {
            this.createTenantSchema(tenantId);
            this.createTenantAsyncJobExecutor(tenantId);
            this.tenantInfoHolder.setCurrentTenantId(tenantId);
            super.postProcessEngineInitialisation();
            this.tenantInfoHolder.clearCurrentTenantId();
        }
    }

    @Override
    public void initAsyncExecutor() {
        if (this.asyncExecutor == null) {
            this.asyncExecutor = new ExecutorPerTenantAsyncExecutor(this.tenantInfoHolder);
        }
        super.initAsyncExecutor();
        if (this.asyncExecutor instanceof TenantAwareAsyncExecutor) {
            for (String tenantId : this.tenantInfoHolder.getAllTenants()) {
                ((TenantAwareAsyncExecutor)this.asyncExecutor).addTenantAsyncExecutor(tenantId, false);
            }
        }
    }

    @Override
    public ProcessEngine buildProcessEngine() {
        String originalDatabaseSchemaUpdate = this.databaseSchemaUpdate;
        this.databaseSchemaUpdate = null;
        boolean originalIsAutoActivateAsyncExecutor = this.asyncExecutorActivate;
        this.asyncExecutorActivate = false;
        ProcessEngine processEngine = super.buildProcessEngine();
        this.databaseSchemaUpdate = originalDatabaseSchemaUpdate;
        this.asyncExecutorActivate = originalIsAutoActivateAsyncExecutor;
        for (String tenantId : this.tenantInfoHolder.getAllTenants()) {
            this.createTenantSchema(tenantId);
        }
        if (this.asyncExecutor != null && originalIsAutoActivateAsyncExecutor) {
            this.asyncExecutor.start();
        }
        this.booted = true;
        return processEngine;
    }

    protected void createTenantSchema(String tenantId) {
        LOGGER.info("creating/validating database schema for tenant {}", (Object)tenantId);
        this.tenantInfoHolder.setCurrentTenantId(tenantId);
        this.getCommandExecutor().execute(this.getSchemaCommandConfig(), (Command)new ExecuteSchemaOperationCommand(this.databaseSchemaUpdate));
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    protected void createTenantAsyncJobExecutor(String tenantId) {
        ((TenantAwareAsyncExecutor)this.asyncExecutor).addTenantAsyncExecutor(tenantId, this.isAsyncExecutorActivate() && this.booted);
    }

    public CommandInterceptor createTransactionInterceptor() {
        return null;
    }

    @Override
    protected void postProcessEngineInitialisation() {
    }

    @Override
    public Runnable getProcessEngineCloseRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                for (String tenantId : MultiSchemaMultiTenantProcessEngineConfiguration.this.tenantInfoHolder.getAllTenants()) {
                    MultiSchemaMultiTenantProcessEngineConfiguration.this.tenantInfoHolder.setCurrentTenantId(tenantId);
                    MultiSchemaMultiTenantProcessEngineConfiguration.this.commandExecutor.execute(MultiSchemaMultiTenantProcessEngineConfiguration.this.getProcessEngineCloseCommand());
                    MultiSchemaMultiTenantProcessEngineConfiguration.this.tenantInfoHolder.clearCurrentTenantId();
                }
            }
        };
    }

    public Command<Void> getProcessEngineCloseCommand() {
        return new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getCommandExecutor().execute((Command)new SchemaOperationProcessEngineClose());
                return null;
            }
        };
    }

    public TenantInfoHolder getTenantInfoHolder() {
        return this.tenantInfoHolder;
    }
}

