/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class EventSubscriptionManager {
    protected void removeObsoleteEventSubscriptionsImpl(ProcessDefinitionEntity processDefinition, String eventHandlerType) {
        EventSubscriptionEntityManager eventSubscriptionEntityManager = CommandContextUtil.getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> subscriptionsToDelete = eventSubscriptionEntityManager.findEventSubscriptionsByTypeAndProcessDefinitionId(eventHandlerType, processDefinition.getId(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
            eventSubscriptionEntityManager.delete(eventSubscriptionEntity);
        }
    }

    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "message");
        }
    }

    protected void removeObsoleteSignalEventSubScription(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "signal");
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                this.insertMessageEvent(messageEventDefinition, startEvent, processDefinition, bpmnModel);
            }
        }
    }

    protected void insertMessageEvent(MessageEventDefinition messageEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageEventDefinition.getMessageRef());
            messageEventDefinition.setMessageRef(message.getName());
        }
        List<EventSubscriptionEntity> subscriptionsForSameMessageName = CommandContextUtil.getEventSubscriptionEntityManager(commandContext).findEventSubscriptionsByName("message", messageEventDefinition.getMessageRef(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
            if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
            throw new FlowableException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + messageEventDefinition.getMessageRef() + "'.");
        }
        MessageEventSubscriptionEntity newSubscription = CommandContextUtil.getEventSubscriptionEntityManager(commandContext).createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setProcessDefinitionId(processDefinition.getId());
        if (processDefinition.getTenantId() != null) {
            newSubscription.setTenantId(processDefinition.getTenantId());
        }
        CommandContextUtil.getEventSubscriptionEntityManager(commandContext).insert(newSubscription);
    }

    protected void addSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof SignalEventDefinition)) continue;
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                SignalEventSubscriptionEntity subscriptionEntity = CommandContextUtil.getEventSubscriptionEntityManager(commandContext).createSignalEventSubscription();
                Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                if (signal != null) {
                    subscriptionEntity.setEventName(signal.getName());
                } else {
                    subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
                }
                subscriptionEntity.setActivityId(startEvent.getId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    subscriptionEntity.setTenantId(processDefinition.getTenantId());
                }
                CommandContextUtil.getEventSubscriptionEntityManager(commandContext).insert(subscriptionEntity);
            }
        }
    }
}

