/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.OIDCProviderCheck;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;

public class OIDCProviderValidator
extends AbstractValidator<OIDCProviderCheck, OIDCProvider> {
    public boolean isValid(OIDCProvider value, ConstraintValidatorContext context) {
        if (value.isSelfRegUnmatching() && value.isCreateUnmatching()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "Either selfRegUnmatching or createUnmatching, not both")).addPropertyNode("selfRegUnmatching").addPropertyNode("createUnmatching").addConstraintViolation();
            return false;
        }
        long connObjectKeys = value.getItems().stream().filter(item -> item.isConnObjectKey()).count();
        if (!value.getItems().isEmpty() && connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean[] isValid = new boolean[]{true};
        long passwords = value.getItems().stream().filter(item -> item.isPassword()).count();
        if (passwords > 0L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "No password mapping is allowed")).addPropertyNode("password.size").addConstraintViolation();
            isValid[0] = false;
        }
        value.getItems().forEach(item -> item.getTransformers().stream().filter(transformer -> transformer.getEngine() == ImplementationEngine.JAVA).forEach(transformer -> {
            Class<?> actionsClass = null;
            boolean isAssignable = false;
            try {
                actionsClass = Class.forName(transformer.getBody());
                isAssignable = ItemTransformer.class.isAssignableFrom(actionsClass);
            }
            catch (Exception e) {
                LOG.error("Invalid ItemTransformer specified: {}", (Object)transformer.getBody(), (Object)e);
            }
            if (actionsClass == null || !isAssignable) {
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Invalid item trasformer class name")).addPropertyNode("itemTransformers").addConstraintViolation();
                isValid[0] = false;
            }
        }));
        return isValid[0];
    }
}

