/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtils;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TaskLogic
extends AbstractExecutableLogic<TaskTO> {
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private TaskExecDAO taskExecDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private TaskDataBinder binder;
    @Autowired
    private PropagationTaskExecutor taskExecutor;
    @Autowired
    private NotificationJobDelegate notificationJobDelegate;
    @Autowired
    private TaskUtilsFactory taskUtilsFactory;

    @PreAuthorize(value="hasRole('TASK_CREATE')")
    public <T extends SchedTaskTO> T createSchedTask(TaskType type, T taskTO) {
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(taskTO);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        SchedTask task = this.binder.createSchedTask(taskTO, taskUtils);
        task = (SchedTask)this.taskDAO.save((Task)task);
        try {
            this.jobManager.register(task, task.getStartAt(), ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_UPDATE')")
    public <T extends SchedTaskTO> T updateSchedTask(TaskType type, SchedTaskTO taskTO) {
        SchedTask task = (SchedTask)this.taskDAO.find(taskTO.getKey());
        if (task == null) {
            throw new NotFoundException("Task " + taskTO.getKey());
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance((Task)task);
        if (taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        this.binder.updateSchedTask(task, taskTO, taskUtils);
        task = (SchedTask)this.taskDAO.save((Task)task);
        try {
            this.jobManager.register(task, task.getStartAt(), ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
        }
        catch (Exception e) {
            LOG.error("While registering quartz job for task " + task.getKey(), (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return (T)((SchedTaskTO)this.binder.getTaskTO((Task)task, taskUtils, false));
    }

    @PreAuthorize(value="hasRole('TASK_LIST')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> Pair<Integer, List<T>> search(TaskType type, String resource, String notification, AnyTypeKind anyTypeKind, String entityKey, int page, int size, List<OrderByClause> orderByClauses, boolean details) {
        try {
            if (type == null) {
                throw new IllegalArgumentException("type is required");
            }
            int count = this.taskDAO.count(type, this.resourceDAO.find(resource), this.notificationDAO.find(notification), anyTypeKind, entityKey);
            List result = this.taskDAO.findAll(type, this.resourceDAO.find(resource), this.notificationDAO.find(notification), anyTypeKind, entityKey, page, size, orderByClauses).stream().map(task -> this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(type), details)).collect(Collectors.toList());
            return Pair.of((Object)count, result);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('TASK_READ')")
    @Transactional(readOnly=true)
    public <T extends TaskTO> T read(TaskType type, String key, boolean details) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        return (T)this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), details);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public ExecTO execute(String key, Date startAt, boolean dryRun) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        if (startAt != null && startAt.before(new Date())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add("Cannot schedule in the past");
            throw sce;
        }
        TaskUtils taskUtil = this.taskUtilsFactory.getInstance(task);
        ExecTO result = null;
        switch (taskUtil.getType()) {
            case PROPAGATION: {
                TaskExec propExec = this.taskExecutor.execute((PropagationTaskTO)this.binder.getTaskTO(task, taskUtil, false));
                result = this.binder.getExecTO(propExec);
                break;
            }
            case NOTIFICATION: {
                TaskExec notExec = this.notificationJobDelegate.executeSingle((NotificationTask)task);
                result = this.binder.getExecTO(notExec);
                break;
            }
            case SCHEDULED: 
            case PULL: 
            case PUSH: {
                if (!((SchedTask)task).isActive()) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add("Task " + key + " is not active");
                    throw sce;
                }
                try {
                    Map jobDataMap = this.jobManager.register((SchedTask)task, startAt, ((Long)this.confDAO.find("tasks.interruptMaxRetries", (Object)1L)).longValue());
                    jobDataMap.put("dryRun", dryRun);
                    if (startAt == null) {
                        this.scheduler.getScheduler().triggerJob(JobNamer.getJobKey((Task)task), new JobDataMap(jobDataMap));
                    }
                }
                catch (Exception e) {
                    LOG.error("While executing task {}", (Object)task, (Object)e);
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
                    sce.getElements().add(e.getMessage());
                    throw sce;
                }
                result = new ExecTO();
                result.setJobType(JobType.TASK);
                result.setRefKey(task.getKey());
                result.setRefDesc(this.binder.buildRefDesc(task));
                result.setStart(new Date());
                result.setStatus("JOB_FIRED");
                result.setMessage("Job fired; waiting for results...");
                break;
            }
        }
        return result;
    }

    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public <T extends TaskTO> T delete(TaskType type, String key) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        TaskUtils taskUtils = this.taskUtilsFactory.getInstance(task);
        if (type != null && taskUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + taskUtils.getType());
            throw sce;
        }
        TaskTO taskToDelete = this.binder.getTaskTO(task, taskUtils, true);
        if (TaskType.SCHEDULED == taskUtils.getType() || TaskType.PULL == taskUtils.getType() || TaskType.PUSH == taskUtils.getType()) {
            this.jobManager.unregister(task);
        }
        this.taskDAO.delete(task);
        return (T)taskToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public Pair<Integer, List<ExecTO>> listExecutions(String key, int page, int size, List<OrderByClause> orderByClauses) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        Integer count = this.taskExecDAO.count(key);
        List result = this.taskExecDAO.findAll(task, page, size, orderByClauses).stream().map(taskExec -> this.binder.getExecTO(taskExec)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<ExecTO> listRecentExecutions(int max) {
        return this.taskExecDAO.findRecent(max).stream().map(taskExec -> this.binder.getExecTO(taskExec)).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public ExecTO deleteExecution(String execKey) {
        TaskExec taskExec = this.taskExecDAO.find(execKey);
        if (taskExec == null) {
            throw new NotFoundException("Task execution " + execKey);
        }
        ExecTO taskExecutionToDelete = this.binder.getExecTO(taskExec);
        this.taskExecDAO.delete(taskExec);
        return taskExecutionToDelete;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_DELETE')")
    public List<BatchResponseItem> deleteExecutions(String key, Date startedBefore, Date startedAfter, Date endedBefore, Date endedAfter) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        ArrayList<BatchResponseItem> batchResponseItems = new ArrayList<BatchResponseItem>();
        this.taskExecDAO.findAll(task, startedBefore, startedAfter, endedBefore, endedAfter).forEach(exec -> {
            BatchResponseItem item = new BatchResponseItem();
            item.getHeaders().put("X-Syncope-Key", Arrays.asList(exec.getKey()));
            batchResponseItems.add(item);
            try {
                this.taskExecDAO.delete(exec);
                item.setStatus(Response.Status.OK.getStatusCode());
            }
            catch (Exception e) {
                LOG.error("Error deleting execution {} of task {}", new Object[]{exec.getKey(), key, e});
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setContent(ExceptionUtils2.getFullStackTrace((Throwable)e));
            }
        });
        return batchResponseItems;
    }

    @Override
    protected Triple<JobType, String, String> getReference(JobKey jobKey) {
        String key = JobNamer.getTaskKeyFromJobName((String)jobKey.getName());
        Task task = this.taskDAO.find(key);
        return task == null || !(task instanceof SchedTask) ? null : Triple.of((Object)JobType.TASK, (Object)key, (Object)this.binder.buildRefDesc(task));
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_LIST')")
    public List<JobTO> listJobs() {
        return super.doListJobs(true);
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_READ')")
    public JobTO getJob(String key) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        JobTO jobTO = null;
        try {
            jobTO = this.getJobTO(JobNamer.getJobKey((Task)task), false);
        }
        catch (SchedulerException e) {
            LOG.error("Problems while retrieving scheduled job {}", (Object)JobNamer.getJobKey((Task)task), (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Scheduling);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (jobTO == null) {
            throw new NotFoundException("Job for task " + key);
        }
        return jobTO;
    }

    @Override
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void actionJob(String key, JobAction action) {
        Task task = this.taskDAO.find(key);
        if (task == null) {
            throw new NotFoundException("Task " + key);
        }
        this.doActionJob(JobNamer.getJobKey((Task)task), action);
    }

    @Override
    protected TaskTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args) && !"deleteExecution".equals(method.getName()) && !"readExecution".equals(method.getName())) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof TaskTO)) continue;
                key = ((TaskTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                Task task = this.taskDAO.find(key);
                return this.binder.getTaskTO(task, this.taskUtilsFactory.getInstance(task), false);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

