/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.RealmDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RealmLogic
extends AbstractTransactionalLogic<RealmTO> {
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private RealmDataBinder binder;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private PropagationTaskExecutor taskExecutor;

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<RealmTO> list(String fullPath) {
        Realm realm = this.realmDAO.findByFullPath(fullPath);
        if (realm == null) {
            LOG.error("Could not find realm '" + fullPath + "'");
            throw new NotFoundException(fullPath);
        }
        boolean admin = AuthContextUtils.getAuthorizations().keySet().contains("REALM_LIST");
        return this.realmDAO.findDescendants(realm).stream().map(descendant -> this.binder.getRealmTO(descendant, admin)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('REALM_CREATE')")
    public ProvisioningResult<RealmTO> create(String parentPath, RealmTO realmTO) {
        Realm parent;
        if (StringUtils.isBlank((CharSequence)realmTO.getParent())) {
            parent = this.realmDAO.findByFullPath(parentPath);
            if (parent == null) {
                LOG.error("Could not find parent realm " + parentPath);
                throw new NotFoundException(parentPath);
            }
            realmTO.setParent(parent.getFullPath());
        } else {
            parent = this.realmDAO.find(realmTO.getParent());
            if (parent == null) {
                LOG.error("Could not find parent realm " + realmTO.getParent());
                throw new NotFoundException(realmTO.getParent());
            }
            if (!parent.getFullPath().equals(parentPath)) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPath);
                sce.getElements().add("Mismatching parent realm: " + parentPath + " Vs " + parent.getFullPath());
                throw sce;
            }
        }
        String fullPath = StringUtils.appendIfMissing((String)parent.getFullPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + realmTO.getName();
        if (this.realmDAO.findByFullPath(fullPath) != null) {
            throw new DuplicateException(fullPath);
        }
        Realm realm = this.realmDAO.save(this.binder.create(parent, realmTO));
        PropagationByResource propByRes = new PropagationByResource();
        realm.getResourceKeys().forEach(resource -> propByRes.add(ResourceOperation.CREATE, resource));
        List tasks = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, false);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_UPDATE')")
    public ProvisioningResult<RealmTO> update(RealmTO realmTO) {
        Realm realm = this.realmDAO.findByFullPath(realmTO.getFullPath());
        if (realm == null) {
            LOG.error("Could not find realm '" + realmTO.getFullPath() + "'");
            throw new NotFoundException(realmTO.getFullPath());
        }
        PropagationByResource propByRes = this.binder.update(realm, realmTO);
        realm = this.realmDAO.save(realm);
        List tasks = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, false);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        return result;
    }

    @PreAuthorize(value="hasRole('REALM_DELETE')")
    public ProvisioningResult<RealmTO> delete(String fullPath) {
        Realm realm = this.realmDAO.findByFullPath(fullPath);
        if (realm == null) {
            LOG.error("Could not find realm '" + fullPath + "'");
            throw new NotFoundException(fullPath);
        }
        if (!this.realmDAO.findChildren(realm).isEmpty()) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.HasChildren);
        }
        Set<String> adminRealms = Collections.singleton(realm.getFullPath());
        AnyCond keyCond = new AnyCond(AttributeCond.Type.ISNOTNULL);
        keyCond.setSchema("key");
        SearchCond allMatchingCond = SearchCond.getLeafCond((AttributeCond)keyCond);
        int users = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.USER);
        int groups = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.GROUP);
        int anyObjects = this.searchDAO.count(adminRealms, allMatchingCond, AnyTypeKind.ANY_OBJECT);
        if (users + groups + anyObjects > 0) {
            SyncopeClientException containedAnys = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.AssociatedAnys);
            containedAnys.getElements().add(users + " user(s)");
            containedAnys.getElements().add(groups + " group(s)");
            containedAnys.getElements().add(anyObjects + " anyObject(s)");
            throw containedAnys;
        }
        PropagationByResource propByRes = new PropagationByResource();
        realm.getResourceKeys().forEach(resource -> propByRes.add(ResourceOperation.DELETE, resource));
        List tasks = this.propagationManager.createTasks(realm, propByRes, null);
        PropagationReporter propagationReporter = this.taskExecutor.execute((Collection)tasks, false);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getRealmTO(realm, true));
        result.getPropagationStatuses().addAll(propagationReporter.getStatuses());
        this.realmDAO.delete(realm);
        return result;
    }

    @Override
    protected RealmTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String fullPath = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; fullPath == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    fullPath = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof RealmTO)) continue;
                fullPath = ((RealmTO)args[i]).getFullPath();
            }
        }
        if (fullPath != null) {
            try {
                return this.binder.getRealmTO(this.realmDAO.findByFullPath(fullPath), true);
            }
            catch (Throwable e) {
                LOG.debug("Unresolved reference", e);
                throw new UnresolvedReferenceException(e);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

