/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.Queue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.syncope.common.lib.collections.CircularFifoQueue;
import org.apache.syncope.common.lib.log.LogStatementTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;

@Plugin(name="Memory", category="Core", elementType="appender", printObject=true)
public class MemoryAppender
extends AbstractAppender {
    private final CircularFifoQueue<LogStatementTO> statements;

    protected MemoryAppender(String name, int size, Filter filter, boolean ignoreExceptions) {
        super(name, filter, null, ignoreExceptions);
        this.statements = new CircularFifoQueue(size);
    }

    public void append(LogEvent event) {
        LogStatementTO statement = new LogStatementTO();
        statement.setLevel(LoggerLevel.fromLevel((Level)event.getLevel()));
        statement.setLoggerName(event.getLoggerName());
        Message msg = event.getMessage();
        statement.setMessage((msg instanceof ReusableMessage ? ((ReusableMessage)msg).memento() : msg).getFormattedMessage());
        statement.setTimeMillis(event.getTimeMillis());
        if (event.getThrown() != null) {
            statement.setStackTrace(ExceptionUtils2.getFullStackTrace((Throwable)event.getThrown()));
        }
        statement.setThreadId(event.getThreadId());
        statement.setThreadName(event.getThreadName());
        statement.setThreadPriority(event.getThreadPriority());
        this.statements.add((Object)statement);
    }

    public Queue<LogStatementTO> getStatements() {
        return this.statements;
    }

    @PluginFactory
    public static MemoryAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="size", defaultInt=10) int size, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        return new MemoryAppender(name, size, filter, ignoreExceptions);
    }
}

