/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.ConnInstanceHistoryConfTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnInstanceHistoryConf;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnectorHistoryLogic
extends AbstractTransactionalLogic<ConnInstanceHistoryConfTO> {
    @Autowired
    private ConnInstanceHistoryConfDAO connInstanceHistoryConfDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private ConnInstanceDataBinder binder;

    @PreAuthorize(value="hasRole('CONNECTOR_HISTORY_LIST')")
    @Transactional(readOnly=true)
    public List<ConnInstanceHistoryConfTO> list(String key) {
        ConnInstance connInstance = this.connInstanceDAO.find(key);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + key + "'");
        }
        return this.connInstanceHistoryConfDAO.findByEntity(connInstance).stream().map(arg_0 -> ((ConnInstanceDataBinder)this.binder).getConnInstanceHistoryConfTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('CONNECTOR_HISTORY_RESTORE')")
    public void restore(String key) {
        ConnInstanceHistoryConf connInstanceHistoryConf = this.connInstanceHistoryConfDAO.find(key);
        if (connInstanceHistoryConf == null) {
            throw new NotFoundException("Connector History Conf '" + key + "'");
        }
        this.binder.update((ConnInstanceTO)connInstanceHistoryConf.getConf());
    }

    @PreAuthorize(value="hasRole('CONNECTOR_HISTORY_DELETE')")
    public void delete(String key) {
        ConnInstanceHistoryConf connInstanceHistoryConf = this.connInstanceHistoryConfDAO.find(key);
        if (connInstanceHistoryConf == null) {
            throw new NotFoundException("Connector History Conf '" + key + "'");
        }
        this.connInstanceHistoryConfDAO.delete(key);
    }

    @Override
    protected ConnInstanceHistoryConfTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        if (!"list".equals(method.getName())) {
            try {
                String key = (String)args[0];
                return this.binder.getConnInstanceHistoryConfTO(this.connInstanceHistoryConfDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

