/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AnyTypeLogic
extends AbstractTransactionalLogic<AnyTypeTO> {
    @Autowired
    private AnyTypeDataBinder binder;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;

    @PreAuthorize(value="hasRole('ANYTYPE_READ')")
    @Transactional(readOnly=true)
    public AnyTypeTO read(String key) {
        AnyType anyType = this.anyTypeDAO.find(key);
        if (anyType == null) {
            LOG.error("Could not find anyType '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getAnyTypeTO(anyType);
    }

    @PreAuthorize(value="hasRole('ANYTYPE_LIST')")
    @Transactional(readOnly=true)
    public List<AnyTypeTO> list() {
        return this.anyTypeDAO.findAll().stream().map(arg_0 -> ((AnyTypeDataBinder)this.binder).getAnyTypeTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('ANYTYPE_CREATE')")
    public AnyTypeTO create(AnyTypeTO anyTypeTO) {
        if (StringUtils.isBlank((CharSequence)anyTypeTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add(AnyType.class.getSimpleName() + " key");
            throw sce;
        }
        if (this.anyTypeDAO.find(anyTypeTO.getKey()) != null) {
            throw new DuplicateException(anyTypeTO.getKey());
        }
        return this.binder.getAnyTypeTO(this.anyTypeDAO.save(this.binder.create(anyTypeTO)));
    }

    @PreAuthorize(value="hasRole('ANYTYPE_UPDATE')")
    public AnyTypeTO update(AnyTypeTO anyTypeTO) {
        AnyType anyType = this.anyTypeDAO.find(anyTypeTO.getKey());
        if (anyType == null) {
            LOG.error("Could not find anyType '" + anyTypeTO.getKey() + "'");
            throw new NotFoundException(anyTypeTO.getKey());
        }
        this.binder.update(anyType, anyTypeTO);
        anyType = this.anyTypeDAO.save(anyType);
        return this.binder.getAnyTypeTO(this.anyTypeDAO.save(anyType));
    }

    @PreAuthorize(value="hasRole('ANYTYPE_DELETE')")
    public AnyTypeTO delete(String key) {
        AnyType anyType = this.anyTypeDAO.find(key);
        if (anyType == null) {
            LOG.error("Could not find anyType '" + key + "'");
            throw new NotFoundException(key);
        }
        Integer anyObjects = (Integer)this.anyObjectDAO.countByType().get(anyType);
        if (anyObjects != null && anyObjects > 0) {
            LOG.error("{} AnyObject instances found for {}, aborting", (Object)anyObjects, (Object)anyType);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add("AnyObject instances found for " + key);
            throw sce;
        }
        try {
            return this.binder.delete(anyType);
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @Override
    protected AnyTypeTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof AnyTypeTO)) continue;
                key = ((AnyTypeTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getAnyTypeTO(this.anyTypeDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

