/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.saml2;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.persistence.api.entity.SAML2IdPItem;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.SAML2IdPActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SAML2UserManager {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2UserManager.class);
    @Autowired
    private SAML2IdPDAO idpDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private TemplateUtils templateUtils;
    @Autowired
    private UserProvisioningManager provisioningManager;
    @Autowired
    private UserDataBinder binder;

    @Transactional(readOnly=true)
    public List<String> findMatchingUser(String keyValue, String idpKey) {
        IntAttrName intAttrName;
        ArrayList<String> result = new ArrayList<String>();
        SAML2IdP idp = this.idpDAO.find(idpKey);
        if (idp == null) {
            LOG.warn("Invalid IdP: {}", (Object)idpKey);
            return result;
        }
        String transformed = keyValue;
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)((Item)idp.getConnObjectKeyItem().get()))) {
            List output = transformer.beforePull(null, null, Collections.singletonList(transformed));
            if (output == null || output.isEmpty()) continue;
            transformed = output.get(0).toString();
        }
        try {
            intAttrName = this.intAttrNameParser.parse(((SAML2IdPItem)idp.getConnObjectKeyItem().get()).getIntAttrName(), AnyTypeKind.USER);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)((SAML2IdPItem)idp.getConnObjectKeyItem().get()).getIntAttrName(), (Object)e);
            return result;
        }
        if (intAttrName.getField() != null) {
            switch (intAttrName.getField()) {
                case "key": {
                    User byKey = (User)this.userDAO.find(transformed);
                    if (byKey == null) break;
                    result.add(byKey.getUsername());
                    break;
                }
                case "username": {
                    User byUsername = this.userDAO.findByUsername(transformed);
                    if (byUsername == null) break;
                    result.add(byUsername.getUsername());
                    break;
                }
            }
        } else if (intAttrName.getSchemaType() != null) {
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    PlainAttrValue value = (PlainAttrValue)this.entityFactory.newEntity(UPlainAttrValue.class);
                    PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                    if (schema == null) {
                        value.setStringValue(transformed);
                    } else {
                        try {
                            value.parseValue(schema, transformed);
                        }
                        catch (ParsingValidationException e) {
                            LOG.error("While parsing provided key value {}", (Object)transformed, (Object)e);
                            value.setStringValue(transformed);
                        }
                    }
                    result.addAll(this.userDAO.findByPlainAttrValue(intAttrName.getSchemaName(), value, false).stream().map(User::getUsername).collect(Collectors.toList()));
                    break;
                }
                case DERIVED: {
                    result.addAll(this.userDAO.findByDerAttrValue(intAttrName.getSchemaName(), transformed, false).stream().map(User::getUsername).collect(Collectors.toList()));
                    break;
                }
            }
        }
        return result;
    }

    private List<SAML2IdPActions> getActions(SAML2IdPEntity idp) {
        ArrayList<SAML2IdPActions> actions = new ArrayList<SAML2IdPActions>();
        idp.getActionsClassNames().forEach(className -> {
            try {
                Class<?> actionsClass = Class.forName(className);
                SAML2IdPActions idpActions = (SAML2IdPActions)ApplicationContextProvider.getBeanFactory().createBean(actionsClass, 2, true);
                actions.add(idpActions);
            }
            catch (Exception e) {
                LOG.warn("Class '{}' not found", className, (Object)e);
            }
        });
        return actions;
    }

    public void fill(String idpKey, SAML2LoginResponseTO responseTO, UserTO userTO) {
        SAML2IdP idp = this.idpDAO.find(idpKey);
        if (idp == null) {
            LOG.warn("Invalid IdP: {}", (Object)idpKey);
            return;
        }
        idp.getItems().forEach(item -> {
            block19: {
                IntAttrName intAttrName;
                List values;
                block18: {
                    values = Collections.emptyList();
                    Optional samlAttr = responseTO.getAttr(item.getExtAttrName());
                    if (samlAttr.isPresent() && !((AttrTO)samlAttr.get()).getValues().isEmpty()) {
                        values = ((AttrTO)samlAttr.get()).getValues();
                        List transformed = new ArrayList(values);
                        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)item)) {
                            transformed = transformer.beforePull(null, (EntityTO)userTO, transformed);
                        }
                        values.clear();
                        for (Object value : transformed) {
                            values.add(value.toString());
                        }
                    }
                    intAttrName = null;
                    try {
                        intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.USER);
                    }
                    catch (ParseException e) {
                        LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
                    }
                    if (intAttrName == null || intAttrName.getField() == null) break block18;
                    switch (intAttrName.getField()) {
                        case "username": {
                            if (!values.isEmpty()) {
                                userTO.setUsername((String)values.get(0));
                                break;
                            }
                            break block19;
                        }
                        default: {
                            LOG.warn("Unsupported: {}", (Object)intAttrName.getField());
                            break;
                        }
                    }
                    break block19;
                }
                if (intAttrName != null && intAttrName.getSchemaType() != null) {
                    switch (intAttrName.getSchemaType()) {
                        case PLAIN: {
                            Optional<AttrTO> attr = userTO.getPlainAttr(intAttrName.getSchemaName());
                            if (attr.isPresent()) {
                                ((AttrTO)attr.get()).getValues().clear();
                            } else {
                                attr = Optional.of(new AttrTO.Builder().schema(intAttrName.getSchemaName()).build());
                                userTO.getPlainAttrs().add(attr.get());
                            }
                            ((AttrTO)attr.get()).getValues().addAll(values);
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported: {} {}", (Object)intAttrName.getSchemaType(), (Object)intAttrName.getSchemaName());
                        }
                    }
                }
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String create(SAML2IdPEntity idp, SAML2LoginResponseTO responseTO, String nameID) {
        UserTO userTO = new UserTO();
        if (idp.getUserTemplate() != null) {
            this.templateUtils.apply((AnyTO)userTO, (AnyTO)idp.getUserTemplate());
        }
        List<SAML2IdPActions> actions = this.getActions(idp);
        for (SAML2IdPActions action : actions) {
            userTO = action.beforeCreate(userTO, responseTO);
        }
        this.fill(idp.getKey(), responseTO, userTO);
        if (userTO.getRealm() == null) {
            userTO.setRealm("/");
        }
        if (userTO.getUsername() == null) {
            userTO.setUsername(nameID);
        }
        Pair created = this.provisioningManager.create(userTO, false, false);
        userTO = this.binder.getUserTO((String)created.getKey());
        for (SAML2IdPActions action : actions) {
            userTO = action.afterCreate(userTO, responseTO);
        }
        return userTO.getUsername();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String update(String username, SAML2IdPEntity idp, SAML2LoginResponseTO responseTO) {
        UserTO userTO = this.binder.getUserTO(this.userDAO.findKey(username));
        UserTO original = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.fill(idp.getKey(), responseTO, userTO);
        UserPatch userPatch = AnyOperations.diff((UserTO)userTO, (UserTO)original, (boolean)true);
        List<SAML2IdPActions> actions = this.getActions(idp);
        for (SAML2IdPActions action : actions) {
            userPatch = action.beforeUpdate(userPatch, responseTO);
        }
        Pair updated = this.provisioningManager.update((AnyPatch)userPatch, false);
        userTO = this.binder.getUserTO(((UserPatch)updated.getLeft()).getKey());
        for (SAML2IdPActions action : actions) {
            userTO = action.afterUpdate(userTO, responseTO);
        }
        return userTO.getUsername();
    }
}

