/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.syncope.common.lib.types.SAML2SPEntitlement;
import org.apache.syncope.core.logic.saml2.SAML2IdPCache;
import org.apache.syncope.core.logic.saml2.SAML2ReaderWriter;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ResourceWithFallbackLoader;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class SAML2SPLoader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SAML2SPLoader.class);
    private static final String SAML2SP_LOGIC_PROPERTIES = "saml2sp-logic.properties";
    @Autowired
    private SAML2ReaderWriter saml2rw;
    @Autowired
    private DomainsHolder domainsHolder;
    @Autowired
    private SAML2IdPCache cache;
    @Autowired
    private SAML2IdPDAO idpDAO;
    private boolean inited;
    private KeyStore keystore;
    private String keyPass;
    private Credential credential;
    private String signatureAlgorithm;

    private static <T> T assertNotNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument '" + name + "' may not be null.");
        }
        return argument;
    }

    public Integer getPriority() {
        return 1000;
    }

    public void load() {
        EntitlementsHolder.getInstance().init((Collection)SAML2SPEntitlement.values());
        Pair init = PropertyUtils.read(this.getClass(), (String)SAML2SP_LOGIC_PROPERTIES, (String)"conf.directory");
        Properties props = (Properties)init.getLeft();
        String confDirectory = (String)init.getRight();
        SAML2SPLoader.assertNotNull(confDirectory, "<conf.directory>");
        String name = props.getProperty("keystore.name");
        SAML2SPLoader.assertNotNull(name, "<keystore.name>");
        String type = props.getProperty("keystore.type");
        SAML2SPLoader.assertNotNull(type, "<keystore.type>");
        String storePass = props.getProperty("keystore.storepass");
        SAML2SPLoader.assertNotNull(storePass, "<keystore.storepass>");
        this.keyPass = props.getProperty("keystore.keypass");
        SAML2SPLoader.assertNotNull(this.keyPass, "<keystore.keypass>");
        String certAlias = props.getProperty("sp.cert.alias");
        SAML2SPLoader.assertNotNull(certAlias, "<sp.cert.alias>");
        this.signatureAlgorithm = props.getProperty("signature.algorithm");
        LOG.debug("Attempting to load the provided keystore...");
        try {
            ResourceWithFallbackLoader loader = new ResourceWithFallbackLoader();
            loader.setResourceLoader((ResourceLoader)ApplicationContextProvider.getApplicationContext());
            loader.setPrimary(StringUtils.appendIfMissing((String)("file:" + confDirectory), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + name);
            loader.setFallback("classpath:" + name);
            this.keystore = KeyStore.getInstance(type);
            try (InputStream inputStream = loader.getResource().getInputStream();){
                this.keystore.load(inputStream, storePass.toCharArray());
                LOG.debug("Keystore loaded");
            }
            HashMap<String, String> passwordMap = new HashMap<String, String>();
            passwordMap.put(certAlias, this.keyPass);
            KeyStoreCredentialResolver resolver = new KeyStoreCredentialResolver(this.keystore, passwordMap);
            this.credential = resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(certAlias)}));
            LOG.debug("SAML 2.0 Service Provider certificate loaded");
            this.saml2rw.init();
            this.inited = true;
        }
        catch (Exception e) {
            LOG.error("Could not initialize the SAML 2.0 Service Provider certificate", (Throwable)e);
            this.inited = false;
        }
        this.domainsHolder.getDomains().keySet().forEach(domain -> AuthContextUtils.execWithAuthContext((String)domain, () -> {
            this.idpDAO.findAll().forEach(idp -> {
                try {
                    this.cache.put((SAML2IdP)idp);
                }
                catch (Exception e) {
                    LOG.error("Could not cache the SAML 2.0 IdP with key ", (Object)idp.getEntityID(), (Object)e);
                }
            });
            return null;
        }));
    }

    public boolean isInited() {
        return this.inited;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    static {
        OpenSAMLUtil.initSamlEngine((boolean)false);
    }
}

