/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.syncope.common.lib.AbstractBaseBean;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.lib.to.SAML2ReceivedResponseTO;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.syncope.core.logic.AbstractSAML2Logic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.saml2.SAML2IdPCache;
import org.apache.syncope.core.logic.saml2.SAML2IdPEntity;
import org.apache.syncope.core.logic.saml2.SAML2ReaderWriter;
import org.apache.syncope.core.logic.saml2.SAML2UserManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SAML2IdPDAO;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.Encryptor;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.NameIDFormatBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class SAML2SPLogic
extends AbstractSAML2Logic<AbstractBaseBean> {
    private static final String IDP_INITIATED_RELAY_STATE = "idpInitiated";
    private static final long JWT_RELAY_STATE_DURATION = 60L;
    private static final String JWT_CLAIM_IDP_DEFLATE = "IDP_DEFLATE";
    private static final String JWT_CLAIM_IDP_ENTITYID = "IDP_ENTITYID";
    private static final String JWT_CLAIM_NAMEID_FORMAT = "NAMEID_FORMAT";
    private static final String JWT_CLAIM_NAMEID_VALUE = "NAMEID_VALUE";
    private static final String JWT_CLAIM_SESSIONINDEX = "SESSIONINDEX";
    private static final RandomBasedGenerator UUID_GENERATOR = Generators.randomBasedGenerator();
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private AccessTokenDataBinder accessTokenDataBinder;
    @Autowired
    private SAML2IdPCache cache;
    @Autowired
    private SAML2UserManager userManager;
    @Autowired
    private SAML2IdPDAO saml2IdPDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Autowired
    private AuthDataAccessor authDataAccessor;
    @Autowired
    private SAML2ReaderWriter saml2rw;
    @Resource(name="accessTokenJwsSignatureVerifier")
    private JwsSignatureVerifier jwsSignatureVerifier;

    private void validateUrl(String url) {
        boolean isValid = true;
        if (url.contains("..")) {
            isValid = false;
        }
        if (isValid) {
            isValid = ResourceUtils.isUrl((String)url);
        }
        if (!isValid) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("Invalid URL: " + url);
            throw sce;
        }
    }

    private String getAssertionConsumerURL(String spEntityID, String urlContext) {
        String assertionConsumerUrl = spEntityID + urlContext + "/assertion-consumer";
        this.validateUrl(assertionConsumerUrl);
        return assertionConsumerUrl;
    }

    @PreAuthorize(value="isAuthenticated()")
    public void getMetadata(String spEntityID, String urlContext, OutputStream os) {
        this.check();
        try {
            EntityDescriptor spEntityDescriptor = new EntityDescriptorBuilder().buildObject();
            spEntityDescriptor.setEntityID(spEntityID);
            SPSSODescriptor spSSODescriptor = new SPSSODescriptorBuilder().buildObject();
            spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
            spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
            spSSODescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
            keyInfoGeneratorFactory.setEmitEntityCertificate(true);
            KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
            keyInfoGenerator.generate(this.loader.getCredential());
            KeyDescriptor keyDescriptor = new KeyDescriptorBuilder().buildObject();
            keyDescriptor.setKeyInfo(keyInfoGenerator.generate(this.loader.getCredential()));
            spSSODescriptor.getKeyDescriptors().add(keyDescriptor);
            NameIDFormat nameIDFormat = new NameIDFormatBuilder().buildObject();
            nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            spSSODescriptor.getNameIDFormats().add(nameIDFormat);
            nameIDFormat = new NameIDFormatBuilder().buildObject();
            nameIDFormat.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            spSSODescriptor.getNameIDFormats().add(nameIDFormat);
            for (SAML2BindingType bindingType : SAML2BindingType.values()) {
                AssertionConsumerService assertionConsumerService = new AssertionConsumerServiceBuilder().buildObject();
                assertionConsumerService.setIndex(Integer.valueOf(bindingType.ordinal()));
                assertionConsumerService.setBinding(bindingType.getUri());
                assertionConsumerService.setLocation(this.getAssertionConsumerURL(spEntityID, urlContext));
                spSSODescriptor.getAssertionConsumerServices().add(assertionConsumerService);
                spEntityDescriptor.getRoleDescriptors().add(spSSODescriptor);
                String sloUrl = spEntityID + urlContext + "/logout";
                this.validateUrl(sloUrl);
                SingleLogoutService singleLogoutService = new SingleLogoutServiceBuilder().buildObject();
                singleLogoutService.setBinding(bindingType.getUri());
                singleLogoutService.setLocation(sloUrl);
                singleLogoutService.setResponseLocation(sloUrl);
                spSSODescriptor.getSingleLogoutServices().add(singleLogoutService);
            }
            spEntityDescriptor.getRoleDescriptors().add(spSSODescriptor);
            this.saml2rw.sign((SignableSAMLObject)spEntityDescriptor);
            this.saml2rw.write(new OutputStreamWriter(os), (XMLObject)spEntityDescriptor, true);
        }
        catch (Exception e) {
            LOG.error("While getting SP metadata", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    private SAML2IdPEntity getIdP(String entityID) {
        SAML2IdPEntity idp = null;
        SAML2IdP saml2IdP = this.saml2IdPDAO.findByEntityID(entityID);
        if (saml2IdP != null) {
            try {
                idp = this.cache.put(saml2IdP);
            }
            catch (Exception e) {
                LOG.error("Could not build SAML 2.0 IdP with key ", (Object)entityID, (Object)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add(e.getMessage());
                throw sce;
            }
        }
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + entityID + "'");
        }
        return idp;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2RequestTO createLoginRequest(String spEntityID, String idpEntityID) {
        SAML2IdPEntity idp;
        this.check();
        SAML2IdPEntity sAML2IdPEntity = idp = StringUtils.isBlank((CharSequence)idpEntityID) ? this.cache.getFirst() : this.cache.get(idpEntityID);
        if (idp == null) {
            if (StringUtils.isBlank((CharSequence)idpEntityID)) {
                List all = this.saml2IdPDAO.findAll();
                if (!all.isEmpty()) {
                    idp = this.getIdP(((SAML2IdP)all.get(0)).getKey());
                }
            } else {
                idp = this.getIdP(idpEntityID);
            }
        }
        if (idp == null) {
            throw new NotFoundException(StringUtils.isBlank((CharSequence)idpEntityID) ? "Any SAML 2.0 IdP" : "SAML 2.0 IdP '" + idpEntityID + "'");
        }
        if (idp.getSSOLocation(idp.getBindingType()) == null) {
            throw new IllegalArgumentException("No SingleSignOnService available for " + idp.getId());
        }
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(spEntityID);
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        if (idp.supportsNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient")) {
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        } else if (idp.supportsNameIDFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent")) {
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        } else {
            throw new IllegalArgumentException("Could not find supported NameIDFormat for IdP " + idpEntityID);
        }
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setSPNameQualifier(spEntityID);
        AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
        requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
        authnRequest.setID("_" + UUID_GENERATOR.generate().toString());
        authnRequest.setForceAuthn(Boolean.valueOf(false));
        authnRequest.setIsPassive(Boolean.valueOf(false));
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setProtocolBinding(idp.getBindingType().getUri());
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(issuer);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        authnRequest.setDestination(idp.getSSOLocation(idp.getBindingType()).getLocation());
        SAML2RequestTO requestTO = new SAML2RequestTO();
        requestTO.setIdpServiceAddress(authnRequest.getDestination());
        requestTO.setBindingType(idp.getBindingType());
        try {
            HashMap<String, Boolean> claims = new HashMap<String, Boolean>();
            claims.put(JWT_CLAIM_IDP_DEFLATE, idp.isUseDeflateEncoding());
            Pair relayState = this.accessTokenDataBinder.generateJWT(UUID_GENERATOR.generate().toString(), authnRequest.getID(), 60L, claims);
            switch (idp.getBindingType()) {
                case REDIRECT: {
                    requestTO.setRelayState(URLEncoder.encode((String)relayState.getLeft(), StandardCharsets.UTF_8.name()));
                    requestTO.setContent(URLEncoder.encode(this.saml2rw.encode((RequestAbstractType)authnRequest, true), StandardCharsets.UTF_8.name()));
                    requestTO.setSignAlg(URLEncoder.encode(this.saml2rw.getSigAlgo(), StandardCharsets.UTF_8.name()));
                    requestTO.setSignature(URLEncoder.encode(this.saml2rw.sign(requestTO.getContent(), requestTO.getRelayState()), StandardCharsets.UTF_8.name()));
                    break;
                }
                default: {
                    requestTO.setRelayState((String)relayState.getLeft());
                    this.saml2rw.sign((SignableSAMLObject)authnRequest);
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)authnRequest, idp.isUseDeflateEncoding()));
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("While generating AuthnRequest", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return requestTO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SAML2LoginResponseTO validateLoginResponse(SAML2ReceivedResponseTO response) {
        Response samlResponse;
        this.check();
        if (response.getRelayState() == null) {
            throw new IllegalArgumentException("No Relay State was provided");
        }
        Boolean useDeflateEncoding = false;
        String requestId = null;
        if (!IDP_INITIATED_RELAY_STATE.equals(response.getRelayState())) {
            JwsJwtCompactConsumer relayState = new JwsJwtCompactConsumer(response.getRelayState());
            if (!relayState.verifySignatureWith(this.jwsSignatureVerifier)) {
                throw new IllegalArgumentException("Invalid signature found in Relay State");
            }
            useDeflateEncoding = Boolean.valueOf(relayState.getJwtClaims().getClaim(JWT_CLAIM_IDP_DEFLATE).toString());
            requestId = relayState.getJwtClaims().getSubject();
            Long expiryTime = relayState.getJwtClaims().getExpiryTime();
            if (expiryTime == null || expiryTime * 1000L < new Date().getTime()) {
                throw new IllegalArgumentException("Relay State is expired");
            }
        }
        if (response.getSamlResponse() == null) {
            throw new IllegalArgumentException("No SAML Response was provided");
        }
        try {
            XMLObject responseObject = this.saml2rw.read(useDeflateEncoding, response.getSamlResponse());
            if (!(responseObject instanceof Response)) {
                throw new IllegalArgumentException("Expected " + Response.class.getName() + ", got " + responseObject.getClass().getName());
            }
            samlResponse = (Response)responseObject;
        }
        catch (Exception e) {
            LOG.error("While parsing AuthnResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (samlResponse.getIssuer() == null || samlResponse.getIssuer().getValue() == null) {
            throw new IllegalArgumentException("The SAML Response must contain an Issuer");
        }
        SAML2IdPEntity idp = this.getIdP(samlResponse.getIssuer().getValue());
        if (idp.getConnObjectKeyItem() == null) {
            throw new IllegalArgumentException("No mapping provided for SAML 2.0 IdP '" + idp.getId() + "'");
        }
        if (IDP_INITIATED_RELAY_STATE.equals(response.getRelayState()) && !idp.isSupportUnsolicited()) {
            throw new IllegalArgumentException("An unsolicited request is not allowed for idp: " + idp.getId());
        }
        SSOValidatorResponse validatorResponse = null;
        try {
            validatorResponse = this.saml2rw.validate(samlResponse, idp, this.getAssertionConsumerURL(response.getSpEntityID(), response.getUrlContext()), requestId, response.getSpEntityID());
        }
        catch (Exception e) {
            LOG.error("While validating AuthnResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        SAML2LoginResponseTO responseTO = new SAML2LoginResponseTO();
        responseTO.setIdp(idp.getId());
        responseTO.setSloSupported(idp.getSLOLocation(idp.getBindingType()) != null);
        Assertion assertion = validatorResponse.getOpensamlAssertion();
        NameID nameID = assertion.getSubject().getNameID();
        if (nameID == null) {
            throw new IllegalArgumentException("NameID not found");
        }
        String keyValue = null;
        if (StringUtils.isNotBlank((CharSequence)nameID.getValue()) && idp.getConnObjectKeyItem().getExtAttrName().equals("NameID")) {
            keyValue = nameID.getValue();
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            responseTO.setNotOnOrAfter(assertion.getConditions().getNotOnOrAfter().toDate());
        }
        assertion.getAuthnStatements().forEach(authnStmt -> {
            responseTO.setSessionIndex(authnStmt.getSessionIndex());
            responseTO.setAuthInstant(authnStmt.getAuthnInstant().toDate());
            if (authnStmt.getSessionNotOnOrAfter() != null) {
                responseTO.setNotOnOrAfter(authnStmt.getSessionNotOnOrAfter().toDate());
            }
        });
        Iterator iterator = assertion.getAttributeStatements().iterator();
        block6: while (true) {
            if (!iterator.hasNext()) {
                String username;
                block33: {
                    List matchingUsers = keyValue == null ? Collections.emptyList() : this.userManager.findMatchingUser(keyValue, idp.getKey());
                    LOG.debug("Found {} matching users for {}", (Object)matchingUsers.size(), (Object)keyValue);
                    if (matchingUsers.isEmpty()) {
                        if (idp.isCreateUnmatching()) {
                            LOG.debug("No user matching {}, about to create", (Object)keyValue);
                            username = (String)AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), () -> this.userManager.create(idp, responseTO, nameID.getValue()));
                            break block33;
                        } else {
                            if (!idp.isSelfRegUnmatching()) {
                                throw new NotFoundException("User matching the provided value " + keyValue);
                            }
                            responseTO.setNameID(nameID.getValue());
                            UserTO userTO = new UserTO();
                            this.userManager.fill(idp.getKey(), responseTO, userTO);
                            responseTO.getAttrs().clear();
                            responseTO.getAttrs().addAll(userTO.getPlainAttrs());
                            responseTO.getAttrs().addAll(userTO.getVirAttrs());
                            if (StringUtils.isNotBlank((CharSequence)userTO.getUsername())) {
                                responseTO.setUsername(userTO.getUsername());
                            }
                            responseTO.setSelfReg(true);
                            return responseTO;
                        }
                    }
                    if (matchingUsers.size() > 1) {
                        throw new IllegalArgumentException("Several users match the provided value " + keyValue);
                    }
                    if (idp.isUpdateMatching()) {
                        LOG.debug("About to update {} for {}", matchingUsers.get(0), (Object)keyValue);
                        username = (String)AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), () -> this.userManager.update((String)matchingUsers.get(0), idp, responseTO));
                    } else {
                        username = (String)matchingUsers.get(0);
                    }
                }
                responseTO.setUsername(username);
                responseTO.setNameID(nameID.getValue());
                HashMap<String, String> claims = new HashMap<String, String>();
                claims.put(JWT_CLAIM_IDP_ENTITYID, idp.getId());
                claims.put(JWT_CLAIM_NAMEID_FORMAT, nameID.getFormat());
                claims.put(JWT_CLAIM_NAMEID_VALUE, nameID.getValue());
                claims.put(JWT_CLAIM_SESSIONINDEX, responseTO.getSessionIndex());
                byte[] authorities = null;
                try {
                    authorities = ENCRYPTOR.encode(POJOHelper.serialize((Object)this.authDataAccessor.getAuthorities(responseTO.getUsername())), CipherAlgorithm.AES).getBytes();
                }
                catch (Exception e) {
                    LOG.error("Could not fetch authorities", (Throwable)e);
                }
                Pair accessTokenInfo = this.accessTokenDataBinder.create(responseTO.getUsername(), claims, authorities, true);
                responseTO.setAccessToken((String)accessTokenInfo.getLeft());
                responseTO.setAccessTokenExpiryTime((Date)accessTokenInfo.getRight());
                return responseTO;
            }
            AttributeStatement attrStmt = (AttributeStatement)iterator.next();
            Iterator iterator2 = attrStmt.getAttributes().iterator();
            while (true) {
                String attrName;
                if (!iterator2.hasNext()) continue block6;
                Attribute attr = (Attribute)iterator2.next();
                if (attr.getAttributeValues().isEmpty()) continue;
                String string = attrName = attr.getFriendlyName() == null ? attr.getName() : attr.getFriendlyName();
                if (attrName.equals(idp.getConnObjectKeyItem().getExtAttrName())) {
                    if (attr.getAttributeValues().get(0) instanceof XSString) {
                        keyValue = ((XSString)attr.getAttributeValues().get(0)).getValue();
                    } else if (attr.getAttributeValues().get(0) instanceof XSAny) {
                        keyValue = ((XSAny)attr.getAttributeValues().get(0)).getTextContent();
                    }
                }
                AttrTO attrTO = new AttrTO();
                attrTO.setSchema(attrName);
                attr.getAttributeValues().stream().filter(value -> value.getDOM() != null).forEachOrdered(value -> attrTO.getValues().add(value.getDOM().getTextContent()));
                responseTO.getAttrs().add(attrTO);
            }
            break;
        }
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public SAML2RequestTO createLogoutRequest(String accessToken, String spEntityID) {
        this.check();
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(accessToken);
        if (!consumer.verifySignatureWith(this.jwsSignatureVerifier)) {
            throw new IllegalArgumentException("Invalid signature found in Access Token");
        }
        String idpEntityID = (String)consumer.getJwtClaims().getClaim(JWT_CLAIM_IDP_ENTITYID);
        if (idpEntityID == null) {
            throw new NotFoundException("No SAML 2.0 IdP information found in the access token");
        }
        SAML2IdPEntity idp = this.cache.get(idpEntityID);
        if (idp == null) {
            throw new NotFoundException("SAML 2.0 IdP '" + idpEntityID + "'");
        }
        if (idp.getSLOLocation(idp.getBindingType()) == null) {
            throw new IllegalArgumentException("No SingleLogoutService available for " + idp.getId());
        }
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setID("_" + UUID_GENERATOR.generate().toString());
        logoutRequest.setDestination(idp.getSLOLocation(idp.getBindingType()).getLocation());
        DateTime now = new DateTime();
        logoutRequest.setIssueInstant(now);
        logoutRequest.setNotOnOrAfter(now.plusMinutes(5));
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(spEntityID);
        logoutRequest.setIssuer(issuer);
        NameID nameID = new NameIDBuilder().buildObject();
        nameID.setFormat((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_NAMEID_FORMAT));
        nameID.setValue((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_NAMEID_VALUE));
        logoutRequest.setNameID(nameID);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex((String)consumer.getJwtClaims().getClaim(JWT_CLAIM_SESSIONINDEX));
        logoutRequest.getSessionIndexes().add(sessionIndex);
        SAML2RequestTO requestTO = new SAML2RequestTO();
        requestTO.setIdpServiceAddress(logoutRequest.getDestination());
        requestTO.setBindingType(idp.getBindingType());
        try {
            HashMap<String, Boolean> claims = new HashMap<String, Boolean>();
            claims.put(JWT_CLAIM_IDP_DEFLATE, idp.getBindingType() == SAML2BindingType.REDIRECT ? true : idp.isUseDeflateEncoding());
            Pair relayState = this.accessTokenDataBinder.generateJWT(UUID_GENERATOR.generate().toString(), logoutRequest.getID(), 60L, claims);
            requestTO.setRelayState((String)relayState.getLeft());
            switch (idp.getBindingType()) {
                case REDIRECT: {
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)logoutRequest, true));
                    requestTO.setSignAlg(this.saml2rw.getSigAlgo());
                    requestTO.setSignature(this.saml2rw.sign(requestTO.getContent(), requestTO.getRelayState()));
                    break;
                }
                default: {
                    this.saml2rw.sign((SignableSAMLObject)logoutRequest);
                    requestTO.setContent(this.saml2rw.encode((RequestAbstractType)logoutRequest, idp.isUseDeflateEncoding()));
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("While generating LogoutRequest", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return requestTO;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public void validateLogoutResponse(String accessToken, SAML2ReceivedResponseTO response) {
        LogoutResponse logoutResponse;
        this.check();
        JwsJwtCompactConsumer consumer = new JwsJwtCompactConsumer(accessToken);
        if (!consumer.verifySignatureWith(this.jwsSignatureVerifier)) {
            throw new IllegalArgumentException("Invalid signature found in Access Token");
        }
        JwsJwtCompactConsumer relayState = null;
        Boolean useDeflateEncoding = false;
        if (StringUtils.isNotBlank((CharSequence)response.getRelayState())) {
            relayState = new JwsJwtCompactConsumer(response.getRelayState());
            if (!relayState.verifySignatureWith(this.jwsSignatureVerifier)) {
                throw new IllegalArgumentException("Invalid signature found in Relay State");
            }
            Long expiryTime = relayState.getJwtClaims().getExpiryTime();
            if (expiryTime == null || expiryTime * 1000L < new Date().getTime()) {
                throw new IllegalArgumentException("Relay State is expired");
            }
            useDeflateEncoding = Boolean.valueOf(relayState.getJwtClaims().getClaim(JWT_CLAIM_IDP_DEFLATE).toString());
        }
        try {
            XMLObject responseObject = this.saml2rw.read(useDeflateEncoding, response.getSamlResponse());
            if (!(responseObject instanceof LogoutResponse)) {
                throw new IllegalArgumentException("Expected " + LogoutResponse.class.getName() + ", got " + responseObject.getClass().getName());
            }
            logoutResponse = (LogoutResponse)responseObject;
        }
        catch (Exception e) {
            LOG.error("While parsing LogoutResponse", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if (relayState != null && !relayState.getJwtClaims().getSubject().equals(logoutResponse.getInResponseTo())) {
            throw new IllegalArgumentException("Unmatching request ID: " + logoutResponse.getInResponseTo());
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(logoutResponse.getStatus().getStatusCode().getValue())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            if (logoutResponse.getStatus().getStatusMessage() == null) {
                sce.getElements().add(logoutResponse.getStatus().getStatusCode().getValue());
            } else {
                sce.getElements().add(logoutResponse.getStatus().getStatusMessage().getMessage());
            }
            throw sce;
        }
        this.accessTokenDAO.delete(consumer.getJwtClaims().getTokenId());
    }

    protected AbstractBaseBean resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

