/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class DeprovisionProducer
extends AbstractProducer {
    private final UserDAO userDAO;
    private final GroupDAO groupDAO;
    private final AnyObjectDAO anyObjectDAO;

    public DeprovisionProducer(Endpoint endpoint, AnyTypeKind anyTypeKind, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO) {
        super(endpoint, anyTypeKind);
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
    }

    public void process(Exchange exchange) throws Exception {
        String key = (String)exchange.getIn().getBody(String.class);
        List resources = (List)exchange.getProperty("resources", List.class);
        Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
        if (null != this.getAnyTypeKind()) {
            PropagationByResource propByRes = new PropagationByResource();
            switch (this.getAnyTypeKind()) {
                case USER: {
                    propByRes.set(ResourceOperation.DELETE, (Collection)resources);
                    List tasks = this.getPropagationManager().getDeleteTasks(AnyTypeKind.USER, key, propByRes, (Collection)this.userDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).collect(Collectors.toList()));
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
                    exchange.getOut().setBody((Object)propagationReporter.getStatuses());
                    break;
                }
                case GROUP: {
                    propByRes.addAll(ResourceOperation.DELETE, (Collection)resources);
                    List tasks = this.getPropagationManager().getDeleteTasks(AnyTypeKind.GROUP, key, propByRes, (Collection)this.groupDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).collect(Collectors.toList()));
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
                    exchange.getOut().setBody((Object)propagationReporter.getStatuses());
                    break;
                }
                case ANY_OBJECT: {
                    propByRes.addAll(ResourceOperation.DELETE, (Collection)resources);
                    List tasks = this.getPropagationManager().getDeleteTasks(AnyTypeKind.ANY_OBJECT, key, propByRes, (Collection)this.anyObjectDAO.findAllResourceKeys(key).stream().filter(resource -> !resources.contains(resource)).collect(Collectors.toList()));
                    PropagationReporter propagationReporter = this.getPropagationTaskExecutor().execute((Collection)tasks, nullPriorityAsync.booleanValue());
                    exchange.getOut().setBody((Object)propagationReporter.getStatuses());
                    break;
                }
            }
        }
    }
}

