/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.camel.AbstractCamelProvisioningManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CamelGroupProvisioningManager
extends AbstractCamelProvisioningManager
implements GroupProvisioningManager {
    public Pair<String, List<PropagationStatus>> create(GroupTO groupTO, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:createGroupPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", Collections.emptySet());
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:createGroup", groupTO, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<String, List<PropagationStatus>> create(GroupTO groupTO, Map<String, String> groupOwnerMap, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:createGroupInPullPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("groupOwnerMap", groupOwnerMap);
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:createGroupInPull", groupTO, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public Pair<GroupPatch, List<PropagationStatus>> update(GroupPatch anyPatch, boolean nullPriorityAsync) {
        return this.update(anyPatch, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pair<GroupPatch, List<PropagationStatus>> update(GroupPatch anyPatch, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:updateGroupPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:updateGroup", anyPatch, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (Pair)exchange.getIn().getBody(Pair.class);
    }

    public List<PropagationStatus> delete(String key, boolean nullPriorityAsync) {
        return this.delete(key, Collections.emptySet(), nullPriorityAsync);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PropagationStatus> delete(String key, Set<String> excludedResources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deleteGroupPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("excludedResources", excludedResources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deleteGroup", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public String unlink(GroupPatch groupPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:unlinkGroupPort");
        this.sendMessage("direct:unlinkGroup", groupPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((GroupPatch)exchange.getIn().getBody(GroupPatch.class)).getKey();
    }

    public String link(GroupPatch groupPatch) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:linkGroupPort");
        this.sendMessage("direct:linkGroup", groupPatch);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return ((GroupPatch)exchange.getIn().getBody(GroupPatch.class)).getKey();
    }

    public List<PropagationStatus> provision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:provisionGroupPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:provisionGroup", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }

    public List<PropagationStatus> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        PollingConsumer pollingConsumer = this.getConsumer("direct:deprovisionGroupPort");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resources", resources);
        props.put("nullPriorityAsync", nullPriorityAsync);
        this.sendMessage("direct:deprovisionGroup", key, props);
        Exchange exchange = pollingConsumer.receive();
        if (exchange.getProperty("CamelExceptionCaught") != null) {
            throw (RuntimeException)exchange.getProperty("CamelExceptionCaught");
        }
        return (List)exchange.getIn().getBody(List.class);
    }
}

