/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.Properties;
import org.apache.syncope.installer.containers.Glassfish;
import org.apache.syncope.installer.containers.Tomcat;
import org.apache.syncope.installer.containers.jboss.JBoss;
import org.apache.syncope.installer.enums.Containers;
import org.apache.syncope.installer.processes.BaseProcess;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.apache.syncope.installer.utilities.MavenUtils;

public final class ContainerProcess
extends BaseProcess {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "8080";
    private String installPath;
    private String mavenDir;
    private String artifactId;
    private String tomcatUser;
    private String tomcatPassword;
    private boolean tomcatSsl;
    private String tomcatHost;
    private String tomcatPort;
    private String glassfishDir;
    private boolean glassfishSsl;
    private String glassfishHost;
    private String glassfishPort;
    private String confDirectory;
    private String logsDirectory;
    private String bundlesDirectory;
    private String modelerDirectory;
    private boolean withDataSource;
    private boolean jbossSsl;
    private String jbossHost;
    private String jbossPort;
    private String jbossJdbcModuleName;
    private String jbossAdminUsername;
    private String jbossAdminPassword;
    private String jbossManagementPort;
    private boolean isProxyEnabled;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPwd;
    private boolean mavenProxyAutoconf;

    @Override
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String port;
        String host;
        String scheme;
        this.installPath = args[0];
        this.mavenDir = args[1];
        this.artifactId = args[2];
        Containers selectedContainer = Containers.fromContainerName(args[3]);
        this.tomcatSsl = Boolean.valueOf(args[4]);
        this.tomcatHost = args[5];
        this.tomcatPort = args[6];
        this.tomcatUser = args[7];
        this.tomcatPassword = args[8];
        this.glassfishSsl = Boolean.valueOf(args[9]);
        this.glassfishHost = args[10];
        this.glassfishPort = args[11];
        this.glassfishDir = args[12];
        this.confDirectory = args[13];
        this.logsDirectory = args[14];
        this.bundlesDirectory = args[15];
        this.modelerDirectory = args[16];
        this.withDataSource = Boolean.valueOf(args[17]);
        this.jbossSsl = Boolean.valueOf(args[18]);
        this.jbossHost = args[19];
        this.jbossPort = args[20];
        this.jbossJdbcModuleName = args[21];
        this.jbossAdminUsername = args[22];
        this.jbossAdminPassword = args[23];
        this.jbossManagementPort = args[24];
        this.isProxyEnabled = Boolean.valueOf(args[25]);
        this.proxyHost = args[26];
        this.proxyPort = args[27];
        this.proxyUser = args[28];
        this.proxyPwd = args[29];
        this.mavenProxyAutoconf = Boolean.valueOf(args[30]);
        handler.logOutput("Configure web.xml file according to " + (Object)((Object)selectedContainer) + " properties", true);
        InstallLog.getInstance().info("Configure web.xml file according to " + (Object)((Object)selectedContainer) + " properties");
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        this.setSyncopeInstallDir(this.installPath, this.artifactId);
        if (this.withDataSource && selectedContainer == Containers.GLASSFISH) {
            File glassfishCoreWebXmlFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("glassfishCoreWebXmlFile"));
            String contentGlassfishWebXmlFile = fileSystemUtils.readFile(glassfishCoreWebXmlFile);
            fileSystemUtils.writeToFile(glassfishCoreWebXmlFile, contentGlassfishWebXmlFile.replace("  <!--<resource-ref>\n    <res-ref-name>jdbc/syncopeDataSource</res-ref-name>\n    <jndi-name>jdbc/syncopeMasterDataSource</jndi-name>\n  </resource-ref>-->", "  <resource-ref>\n    <res-ref-name>jdbc/syncopeDataSource</res-ref-name>\n    <jndi-name>jdbc/syncopeMasterDataSource</jndi-name>\n  </resource-ref>"));
        }
        File consolePropertiesFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("consoleResDirectory") + File.separator + PROPERTIES.getProperty("consolePropertiesFile"));
        String contentConsolePropertiesFile = fileSystemUtils.readFile(consolePropertiesFile);
        File enduserPropertiesFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("enduserResDirectory") + File.separator + PROPERTIES.getProperty("enduserPropertiesFile"));
        String contentEnduserPropertiesFile = fileSystemUtils.readFile(enduserPropertiesFile);
        switch (selectedContainer) {
            case TOMCAT: {
                scheme = this.tomcatSsl ? HTTPS : HTTP;
                host = this.tomcatHost;
                port = this.tomcatPort;
                break;
            }
            case JBOSS: {
                scheme = this.jbossSsl ? HTTPS : HTTP;
                host = this.jbossHost;
                port = this.jbossPort;
                this.persistenceContextEMFactory(fileSystemUtils, handler);
                break;
            }
            case GLASSFISH: {
                scheme = this.glassfishSsl ? HTTPS : HTTP;
                host = this.glassfishHost;
                port = this.glassfishPort;
                break;
            }
            default: {
                scheme = HTTP;
                host = DEFAULT_HOST;
                port = DEFAULT_PORT;
            }
        }
        fileSystemUtils.writeToFile(consolePropertiesFile, contentConsolePropertiesFile.replace("scheme=http\nhost=localhost\nport=8080", String.format("scheme=%s%nhost=%s%nport=%s", scheme, host, port)));
        fileSystemUtils.writeToFile(enduserPropertiesFile, contentEnduserPropertiesFile.replace("scheme=http\nhost=localhost\nport=8080", String.format("scheme=%s%nhost=%s%nport=%s", scheme, host, port)));
        MavenUtils mavenUtils = new MavenUtils(this.mavenDir, handler);
        File customMavenProxySettings = null;
        if (this.isProxyEnabled && this.mavenProxyAutoconf) {
            try {
                customMavenProxySettings = MavenUtils.createSettingsWithProxy(this.installPath, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPwd);
            }
            catch (Exception e) {
                StringBuilder message = new StringBuilder("Error during creation of custom Maven settings.xml");
                handler.emitError(message.toString(), e.getMessage());
                InstallLog.getInstance().error(message.append('\n').append(e.getMessage()).toString());
            }
        }
        Properties mvnProperties = new Properties();
        mvnProperties.setProperty("conf.directory", this.confDirectory);
        mvnProperties.setProperty("log.directory", this.logsDirectory);
        mvnProperties.setProperty("bundles.directory", this.bundlesDirectory);
        mvnProperties.setProperty("flowable-modeler.directory", this.modelerDirectory);
        mavenUtils.mvnCleanPackageWithProperties(this.installPath + File.separator + this.artifactId, mvnProperties, customMavenProxySettings);
        if (this.isProxyEnabled && this.mavenProxyAutoconf) {
            FileSystemUtils.delete(customMavenProxySettings);
        }
        switch (selectedContainer) {
            case TOMCAT: {
                Tomcat tomcat = new Tomcat(this.tomcatSsl, this.tomcatHost, this.tomcatPort, this.installPath, this.artifactId, this.tomcatUser, this.tomcatPassword, handler);
                boolean deployCoreResult = tomcat.deployCore();
                if (deployCoreResult) {
                    handler.logOutput("Core successfully deployed ", true);
                    InstallLog.getInstance().info("Core successfully deployed ");
                } else {
                    String messageError = "Core deploy failed";
                    handler.emitError(messageError, messageError);
                    InstallLog.getInstance().error(messageError);
                }
                boolean deployConsoleResult = tomcat.deployConsole();
                if (deployConsoleResult) {
                    handler.logOutput("Console successfully deployed ", true);
                    InstallLog.getInstance().info("Console successfully deployed ");
                } else {
                    String messageError = "Console deploy failed";
                    handler.emitError("Console deploy failed", "Console deploy failed");
                    InstallLog.getInstance().error("Console deploy failed");
                }
                boolean deployEnduserResult = tomcat.deployEnduser();
                if (deployEnduserResult) {
                    handler.logOutput("Enduser successfully deployed ", true);
                    InstallLog.getInstance().info("Enduser successfully deployed ");
                    break;
                }
                String messageError = "Enduser deploy failed";
                handler.emitError("Enduser deploy failed", "Enduser deploy failed");
                InstallLog.getInstance().error("Enduser deploy failed");
                break;
            }
            case JBOSS: {
                JBoss jBoss = new JBoss(this.jbossSsl, this.jbossHost, this.jbossManagementPort, this.jbossAdminUsername, this.jbossAdminPassword, this.installPath, this.artifactId, handler);
                boolean deployCoreJboss = jBoss.deployCore();
                if (deployCoreJboss) {
                    handler.logOutput("Core successfully deployed ", true);
                    InstallLog.getInstance().info("Core successfully deployed ");
                } else {
                    String messageError = "Core deploy failed";
                    handler.emitError(messageError, messageError);
                    InstallLog.getInstance().error(messageError);
                }
                boolean deployConsoleJBoss = jBoss.deployConsole();
                if (deployConsoleJBoss) {
                    handler.logOutput("Console successfully deployed ", true);
                    InstallLog.getInstance().info("Console successfully deployed ");
                } else {
                    String messageError = "Console deploy failed";
                    handler.emitError("Console deploy failed", "Console deploy failed");
                    InstallLog.getInstance().error("Console deploy failed");
                }
                boolean deployEnduserJBoss = jBoss.deployEnduser();
                if (deployEnduserJBoss) {
                    handler.logOutput("Enduser successfully deployed ", true);
                    InstallLog.getInstance().info("Enduser successfully deployed ");
                    break;
                }
                String messageError = "Enduser deploy failed";
                handler.emitError("Enduser deploy failed", "Enduser deploy failed");
                InstallLog.getInstance().error("Enduser deploy failed");
                break;
            }
            case GLASSFISH: {
                String createJavaOptCommand = "sh " + this.glassfishDir + "/bin/asadmin create-jvm-options-Dcom.sun.enterprise.overrideablejavaxpackages=javax.ws.rs,javax.ws.rs.core,javax.ws.rs.ext";
                fileSystemUtils.exec(createJavaOptCommand, null);
                Glassfish glassfish = new Glassfish(this.installPath, this.artifactId);
                fileSystemUtils.exec("sh " + this.glassfishDir + "/bin/asadmin deploy " + glassfish.deployCore(), null);
                fileSystemUtils.exec("sh " + this.glassfishDir + "/bin/asadmin deploy " + glassfish.deployConsole(), null);
                fileSystemUtils.exec("sh " + this.glassfishDir + "/bin/asadmin deploy " + glassfish.deployEnduser(), null);
                break;
            }
        }
    }

    private void persistenceContextEMFactory(FileSystemUtils fileSystemUtils, AbstractUIProcessHandler handler) {
        fileSystemUtils.copyFileFromResources("/MasterDomain.xml", this.syncopeInstallDir + PROPERTIES.getProperty("masterDomainFile"), handler);
        File masterDomainFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("masterDomainFile"));
        String contentPersistenceContextEMFactory = fileSystemUtils.readFile(masterDomainFile);
        fileSystemUtils.writeToFile(masterDomainFile, contentPersistenceContextEMFactory.replace("<entry key=\"openjpa.MetaDataFactory\" \n               value=\"jpa(URLs=vfs:${project.build.directory}/cargo/configurations/wildfly9x/deployments/syncope.war/WEB-INF/classes, Resources=${Master.orm})\"/>\n", "<entry key=\"openjpa.MetaDataFactory\" value=\"jpa(URLs=vfs:/content/${project.build.finalName}.war/WEB-INF/classes/, Resources=${Master.orm})\"/>"));
    }
}

