/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.Properties;
import org.apache.syncope.installer.processes.BaseProcess;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.apache.syncope.installer.utilities.MavenUtils;

public class ArchetypeProcess
extends BaseProcess {
    @Override
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String contentPomFile;
        File pomFile;
        String installPath = args[0];
        String mavenDir = args[1];
        String groupId = args[2];
        String artifactId = args[3];
        String secretKey = args[4];
        String anonymousKey = args[5];
        String confDirectory = args[6];
        String logsDirectory = args[7];
        String bundlesDirectory = args[8];
        String modelerDirectory = args[9];
        String syncopeVersion = args[10];
        String syncopeAdminPassword = args[11];
        boolean isProxyEnabled = Boolean.valueOf(args[12]);
        String proxyHost = args[13];
        String proxyPort = args[14];
        String proxyUser = args[15];
        String proxyPwd = args[16];
        boolean mavenProxyAutoconf = Boolean.valueOf(args[17]);
        boolean swagger = Boolean.valueOf(args[18]);
        boolean flowable = Boolean.valueOf(args[19]);
        String jwsKey = args[20];
        this.setSyncopeInstallDir(installPath, artifactId);
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        fileSystemUtils.createDirectory(installPath);
        InstallLog.initialize(installPath, handler);
        MavenUtils mavenUtils = new MavenUtils(mavenDir, handler);
        File customMavenProxySettings = null;
        if (isProxyEnabled && mavenProxyAutoconf) {
            try {
                customMavenProxySettings = MavenUtils.createSettingsWithProxy(installPath, proxyHost, proxyPort, proxyUser, proxyPwd);
            }
            catch (Exception e) {
                StringBuilder message = new StringBuilder("Error during creation of custom Maven settings.xml");
                handler.emitError(message.toString(), e.getMessage());
                InstallLog.getInstance().error(message.append('\n').append(e.getMessage()).toString());
            }
        }
        handler.logOutput("########################## IMPORTANT ##########################", true);
        handler.logOutput("See " + InstallLog.getInstance().getFileAbsolutePath() + " for the maven logs", true);
        handler.logOutput("########################## IMPORTANT ##########################", true);
        mavenUtils.archetypeGenerate(syncopeVersion, groupId, artifactId, secretKey, anonymousKey, jwsKey, syncopeAdminPassword, installPath, customMavenProxySettings);
        if (syncopeVersion.contains("SNAPSHOT")) {
            pomFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</project>", "  <repositories>\n    <repository>\n      <id>ASF</id>\n      <url>https://repository.apache.org/content/repositories/snapshots/</url>\n      <snapshots>\n        <enabled>true</enabled>\n      </snapshots>\n    </repository>\n  </repositories>\n</project>\n"));
        }
        if (swagger) {
            pomFile = new File(this.syncopeInstallDir + File.separator + "core" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "  <dependency>\n      <groupId>org.apache.syncope.ext</groupId>\n      <artifactId>syncope-ext-swagger-ui</artifactId>\n      <version>${syncope.version}</version>\n    </dependency>\n  </dependencies>\n"));
        }
        fileSystemUtils.createDirectory(confDirectory);
        fileSystemUtils.createDirectory(logsDirectory);
        fileSystemUtils.createDirectory(bundlesDirectory);
        fileSystemUtils.createDirectory(modelerDirectory);
        if (flowable) {
            pomFile = new File(this.syncopeInstallDir + File.separator + "core" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "    <dependency>\n      <groupId>org.apache.syncope.core</groupId>\n      <artifactId>syncope-core-workflow-flowable</artifactId>\n    </dependency>\n  </dependencies>\n"));
            fileSystemUtils.copyFileFromResources("/workflow.properties", this.syncopeInstallDir + PROPERTIES.getProperty("workflowPropertiesFile"), handler);
            pomFile = new File(this.syncopeInstallDir + File.separator + "console" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "<dependency>\n          <groupId>org.flowable</groupId>\n          <artifactId>flowable-ui-modeler-app</artifactId>\n          <type>war</type>\n          <scope>test</scope>\n        </dependency>\n  </dependencies>\n").replace("</finalName>", "</finalName><plugins>\n          <plugin>\n            <groupId>org.apache.maven.plugins</groupId>\n            <artifactId>maven-antrun-plugin</artifactId>\n            <inherited>true</inherited>\n            <executions>\n              <execution>\n                <id>setupFlowableModeler</id>\n                <phase>process-resources</phase>\n                <configuration>\n                  <target>\n                <unzip src=\"${settings.localRepository}/org/flowable/flowable-ui-modeler-app/${flowable.version}/flowable-ui-modeler-app-${flowable.version}.war\" \n                       dest=\"${flowable-modeler.directory}\">\n                  <patternset>\n                    <include name=\"WEB-INF/classes/static/**\"/>\n                    <include name=\"WEB-INF/lib/flowable-ui-modeler-logic-${flowable.version}.jar\"/>\n                  </patternset>\n                </unzip>\n                \n                <unzip src=\"${flowable-modeler.directory}/WEB-INF/lib/flowable-ui-modeler-logic-${flowable.version}.jar\"\n                       dest=\"${flowable-modeler.directory}\">\n                  <patternset>\n                    <include name=\"stencilset_bpmn.json\"/>\n                  </patternset>\n                </unzip>\n                \n                <move todir=\"${flowable-modeler.directory}\">\n                  <fileset dir=\"${flowable-modeler.directory}/WEB-INF/classes/static/\">\n                    <include name=\"**\"/>\n                  </fileset>\n                </move>\n                <delete dir=\"${flowable-modeler.directory}/WEB-INF\"/>\n                \n                <replace file=\"${flowable-modeler.directory}/index.html\"\n                         token=\"&lt;/head&gt;\"\n                         value=\"&lt;script type=&quot;text/javascript&quot;&gt;window.onunload = refreshParent; function refreshParent() { window.opener.location.reload(); }&lt;/script&gt;&lt;/head&gt;\"/>\n                <replace file=\"${flowable-modeler.directory}/index.html\"\n                         token=\" ng-click=&quot;backToLanding()&quot;\"\n                         value=\" disabled=&quot;disabled&quot;\"/>\n                <replace file=\"${flowable-modeler.directory}/index.html\"\n                         token=\"&lt;ul class=&quot;nav navbar-nav&quot; id=&quot;main-nav&quot;\"\n                         value=\"&lt;ul class=&quot;nav navbar-nav&quot; id=&quot;main-nav&quot; style=&quot;display: none;&quot;\"/>\n                <replace file=\"${flowable-modeler.directory}/index.html\"\n                         token=\"&lt;div class=&quot;pull-right\"\n                         value=\"&lt;div style=&quot;display: none;&quot; class=&quot;pull-right\"/>\n                <replace file=\"${flowable-modeler.directory}/editor-app/editor.html\"\n                         token=\"&lt;div class=&quot;btn-group pull-right&quot;\"\n                         value=\"&lt;div style=&quot;display: none;&quot; class=&quot;btn-group pull-right&quot;\"/>\n                <replace file=\"${flowable-modeler.directory}/editor-app/configuration/toolbar-default-actions.js\"\n                         token=\"$location.path('/processes');\"\n                         value=\"window.close();\"/>\n \n                <copy file=\"${basedir}/src/main/resources/app-cfg.js\" \n                      todir=\"${flowable-modeler.directory}/scripts\"\n                      overwrite=\"true\"/>\n                <copy file=\"${basedir}/src/main/resources/url-config.js\" \n                      todir=\"${flowable-modeler.directory}/editor-app/configuration\"\n                      overwrite=\"true\"/>\n                <copy file=\"${basedir}/src/main/resources/toolbar.js\" \n                      todir=\"${flowable-modeler.directory}/editor-app/configuration\"\n                      overwrite=\"true\"/>\n                <copy file=\"${basedir}/src/main/resources/save-model.html\" \n                      todir=\"${flowable-modeler.directory}/editor-app/popups\"\n                      overwrite=\"true\"/>                  </target>\n                </configuration>\n                <goals>\n                  <goal>run</goal>\n                </goals>\n              </execution>\n            </executions>\n          </plugin>\n        </plugins>"));
        }
        Properties syncopeProperties = new Properties();
        syncopeProperties.setProperty("conf.directory", confDirectory);
        syncopeProperties.setProperty("log.directory", logsDirectory);
        syncopeProperties.setProperty("bundles.directory", bundlesDirectory);
        syncopeProperties.setProperty("flowable-modeler.directory", modelerDirectory);
        mavenUtils.mvnCleanPackageWithProperties(installPath + File.separator + artifactId, syncopeProperties, customMavenProxySettings);
    }
}

