/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import java.io.File;

public class FileFieldView {
    private final AbstractFileField field;
    private final Prompt prompt;

    public FileFieldView(AbstractFileField field, Prompt prompt) {
        this.field = field;
        this.prompt = prompt;
    }

    public AbstractFileField getField() {
        return this.field;
    }

    public boolean validate(String path) {
        boolean empty;
        boolean result = false;
        boolean bl = empty = path == null || path.length() == 0;
        if (empty) {
            if (this.field.getAllowEmptyValue()) {
                result = true;
            } else {
                this.emptyPathMessage();
            }
        } else {
            File file = this.field.getAbsoluteFile(path);
            path = file.toString();
            if (this.validate(file)) {
                ValidationStatus status = this.field.validate(path);
                if (!status.isValid()) {
                    this.prompt.message(Prompt.Type.WARNING, this.getMessage("UserInputPanel.error.caption"), status.getMessage());
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    protected Prompt getPrompt() {
        return this.prompt;
    }

    protected String getMessage(String id) {
        Messages messages = this.field.getInstallData().getMessages();
        return messages.get(id, new Object[0]);
    }

    protected boolean validate(File value) {
        boolean result = false;
        if (!this.field.mustExist || value.isFile()) {
            result = true;
        } else {
            this.warn(this.getMessage("UserInputPanel.file.notfile.caption"), this.getMessage("UserInputPanel.file.notfile.message"));
        }
        return result;
    }

    protected void emptyPathMessage() {
        this.warn(this.getMessage("UserInputPanel.file.nofile.caption"), this.getMessage("UserInputPanel.file.nofile.message"));
    }

    protected void warn(String title, String message) {
        this.prompt.warn(title, message);
    }

    protected void error(String title, String message) {
        this.prompt.error(title, message);
    }
}

