/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Constraint;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InvalidStateException;

public abstract class LocalConstraint
extends Constraint {
    private static final Localizer _loc = Localizer.forPackage(LocalConstraint.class);
    private List<Column> _colList = null;
    private Column[] _cols = null;

    public LocalConstraint() {
    }

    public LocalConstraint(String name, Table table) {
        super(name, table);
    }

    public LocalConstraint(DBIdentifier name, Table table) {
        super(name, table);
    }

    @Override
    void remove() {
        for (Column c : this._cols) {
            c.removeConstraint(this);
        }
        this.setColumns(null);
        super.remove();
    }

    public Column[] getColumns() {
        if (this._cols == null) {
            this._cols = this._colList == null ? Schemas.EMPTY_COLUMNS : this._colList.toArray(new Column[this._colList.size()]);
        }
        return this._cols;
    }

    public void setColumns(Column[] cols) {
        int i;
        Column[] cur = this.getColumns();
        for (i = 0; i < cur.length; ++i) {
            this.removeColumn(cur[i]);
        }
        if (cols != null) {
            for (i = 0; i < cols.length; ++i) {
                this.addColumn(cols[i]);
            }
        }
    }

    public void addColumn(Column col) {
        if (col == null) {
            throw new InvalidStateException(_loc.get("table-mismatch", (Object)(col == null ? null : col.getTable()), (Object)(col == null ? null : this.getTable())));
        }
        if (this._colList == null) {
            this._colList = new ArrayList<Column>(3);
        } else if (this._colList.contains(col)) {
            return;
        }
        this._colList.add(col);
        this._cols = null;
        col.addConstraint(this);
    }

    public boolean removeColumn(Column col) {
        if (col == null || this._colList == null) {
            return false;
        }
        if (this._colList.remove(col)) {
            this._cols = null;
            col.removeConstraint(this);
            return true;
        }
        return false;
    }

    public boolean containsColumn(Column col) {
        if (col == null || this._colList == null) {
            return false;
        }
        return this._colList.contains(col);
    }

    public void refColumns() {
        Column[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            cols[i].ref();
        }
    }

    public void derefColumns() {
        Column[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            cols[i].deref();
        }
    }

    public boolean columnsMatch(Column[] ocols) {
        Column[] cols = this.getColumns();
        if (cols.length != ocols.length) {
            return false;
        }
        for (int i = 0; i < ocols.length; ++i) {
            if (LocalConstraint.hasColumn(cols, ocols[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean hasColumn(Column[] cols, Column col) {
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getQualifiedPath().equals(col.getQualifiedPath())) continue;
            return true;
        }
        return false;
    }

    protected boolean equalsLocalConstraint(LocalConstraint lc) {
        if (lc == this) {
            return true;
        }
        if (lc == null) {
            return false;
        }
        return this.columnsMatch(lc.getColumns());
    }
}

