/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.CacheStatisticsImpl;
import org.apache.openjpa.datacache.CacheStatisticsSPI;
import org.apache.openjpa.datacache.Caches;
import org.apache.openjpa.datacache.ClearableScheduler;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCacheManagerImpl;
import org.apache.openjpa.datacache.DataCacheMode;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.ExpirationEvent;
import org.apache.openjpa.datacache.ExpirationListener;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;
import org.apache.openjpa.util.GeneralException;

public abstract class AbstractDataCache
extends AbstractConcurrentEventManager
implements DataCache,
Configurable {
    protected CacheStatisticsSPI _stats = new CacheStatisticsImpl();
    private static final BitSet EMPTY_BITSET = new BitSet(0);
    private static final Localizer s_loc = Localizer.forPackage(AbstractDataCache.class);
    protected OpenJPAConfiguration conf;
    protected Log log;
    private String _name = null;
    private boolean _closed = false;
    private String _schedule = null;
    protected Set<String> _includedTypes = new HashSet<String>();
    protected Set<String> _excludedTypes = new HashSet<String>();
    protected boolean _evictOnBulkUpdate = true;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    public void setEnableStatistics(boolean enable) {
        if (enable) {
            this._stats.enable();
        }
    }

    public void getEnableStatistics() {
        this._stats.isEnabled();
    }

    public String getEvictionSchedule() {
        return this._schedule;
    }

    public void setEvictionSchedule(String s) {
        this._schedule = s;
    }

    @Override
    public void initialize(DataCacheManager manager) {
        ClearableScheduler scheduler;
        if (this._schedule != null && !"".equals(this._schedule) && (scheduler = manager.getClearableScheduler()) != null) {
            scheduler.scheduleEviction(this, this._schedule);
        }
        if (manager instanceof DataCacheManagerImpl) {
            ArrayList<String> invalidConfigured = new ArrayList<String>();
            if (this._includedTypes != null) {
                for (String s : this._includedTypes) {
                    if (!this._excludedTypes.contains(s)) continue;
                    invalidConfigured.add(s);
                }
                if (invalidConfigured.size() > 0) {
                    throw new GeneralException(s_loc.get("invalid-types-excluded-types", (Object)((Object)invalidConfigured).toString()));
                }
            }
            ((DataCacheManagerImpl)manager).setTypes(this._includedTypes, this._excludedTypes);
        }
    }

    @Override
    public void commit(Collection<DataCachePCData> additions, Collection<DataCachePCData> newUpdates, Collection<DataCachePCData> existingUpdates, Collection<Object> deletes) {
        this.removeAllInternal(deletes);
        this.putAllInternal(additions);
        this.putAllInternal(newUpdates);
        if (this.recacheUpdates()) {
            this.putAllInternal(existingUpdates);
        }
        if (this.log.isTraceEnabled()) {
            ArrayList<Object> addIds = new ArrayList<Object>(additions.size());
            ArrayList<Object> upIds = new ArrayList<Object>(newUpdates.size());
            ArrayList<Object> exIds = new ArrayList<Object>(existingUpdates.size());
            for (DataCachePCData addition : additions) {
                addIds.add(addition.getId());
            }
            for (DataCachePCData newUpdate : newUpdates) {
                upIds.add(newUpdate.getId());
            }
            for (DataCachePCData existingUpdate : existingUpdates) {
                exIds.add(existingUpdate.getId());
            }
            this.log.trace((Object)s_loc.get("cache-commit", new Object[]{addIds, upIds, exIds, deletes}));
        }
    }

    @Override
    public boolean contains(Object key) {
        DataCachePCData o = this.getInternal(key);
        if (o != null && o.isTimedOut()) {
            o = null;
            this.removeInternal(key);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)s_loc.get("cache-timeout", key));
            }
        }
        return o != null;
    }

    @Override
    public BitSet containsAll(Collection<Object> keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public DataCachePCData get(Object key) {
        DataCachePCData o = this.getInternal(key);
        if (o != null && o.isTimedOut()) {
            o = null;
            this.removeInternal(key);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)s_loc.get("cache-timeout", key));
            }
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace((Object)s_loc.get("cache-miss", key));
            } else {
                this.log.trace((Object)s_loc.get("cache-hit", key));
            }
        }
        return o;
    }

    @Override
    public Map<Object, DataCachePCData> getAll(List<Object> keys) {
        HashMap<Object, DataCachePCData> resultMap = new HashMap<Object, DataCachePCData>(keys.size());
        for (Object key : keys) {
            resultMap.put(key, this.get(key));
        }
        return resultMap;
    }

    @Override
    public DataCachePCData put(DataCachePCData data) {
        DataCachePCData o = this.putInternal(data.getId(), data);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)s_loc.get("cache-put", data.getId()));
        }
        return o == null || o.isTimedOut() ? null : o;
    }

    @Override
    public void update(DataCachePCData data) {
        if (this.recacheUpdates()) {
            this.putInternal(data.getId(), data);
        }
    }

    @Override
    public DataCachePCData remove(Object key) {
        DataCachePCData o = this.removeInternal(key);
        if (o != null && o.isTimedOut()) {
            o = null;
        }
        if (this.log.isTraceEnabled()) {
            if (o == null) {
                this.log.trace((Object)s_loc.get("cache-remove-miss", key));
            } else {
                this.log.trace((Object)s_loc.get("cache-remove-hit", key));
            }
        }
        return o;
    }

    @Override
    public BitSet removeAll(Collection<Object> keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.remove(iter.next()) != null) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public void removeAll(Class<?> cls, boolean subClasses) {
        this.removeAllInternal(cls, subClasses);
    }

    @Override
    public boolean pin(Object key) {
        boolean bool = this.pinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace((Object)s_loc.get("cache-pin-hit", key));
            } else {
                this.log.trace((Object)s_loc.get("cache-pin-miss", key));
            }
        }
        return bool;
    }

    @Override
    public BitSet pinAll(Collection<Object> keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.pin(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public void pinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("cache-class-pin", (Object)this.getName()));
        }
    }

    @Override
    public boolean unpin(Object key) {
        boolean bool = this.unpinInternal(key);
        if (this.log.isTraceEnabled()) {
            if (bool) {
                this.log.trace((Object)s_loc.get("cache-unpin-hit", key));
            } else {
                this.log.trace((Object)s_loc.get("cache-unpin-miss", key));
            }
        }
        return bool;
    }

    @Override
    public BitSet unpinAll(Collection<Object> keys) {
        if (keys.isEmpty()) {
            return EMPTY_BITSET;
        }
        BitSet set = new BitSet(keys.size());
        int i = 0;
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            if (this.unpin(iter.next())) {
                set.set(i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public void unpinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("cache-class-unpin", (Object)this.getName()));
        }
    }

    @Override
    public void clear() {
        this.clearInternal();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)s_loc.get("cache-clear", (Object)this.getName()));
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    protected void close(boolean clear) {
        if (!this._closed) {
            if (clear) {
                this.clearInternal();
            }
            this._closed = true;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void addExpirationListener(ExpirationListener listen) {
        this.addListener(listen);
    }

    @Override
    public boolean removeExpirationListener(ExpirationListener listen) {
        return this.removeListener(listen);
    }

    public String toString() {
        return "[" + super.toString() + ":" + this._name + "]";
    }

    public void afterCommit(RemoteCommitEvent event) {
        if (this._closed) {
            return;
        }
        if (event.getPayloadType() == 2) {
            this.removeAllTypeNamesInternal(event.getUpdatedTypeNames());
            this.removeAllTypeNamesInternal(event.getDeletedTypeNames());
        } else {
            this.removeAllInternal(event.getUpdatedObjectIds());
            this.removeAllInternal(event.getDeletedObjectIds());
        }
    }

    protected void keyRemoved(Object key, boolean expired) {
        if (this.hasListeners()) {
            this.fireEvent(new ExpirationEvent(this, key, expired));
        }
        if (expired && this.log.isTraceEnabled()) {
            this.log.trace((Object)s_loc.get("cache-expired", key));
        }
    }

    protected boolean recacheUpdates() {
        return false;
    }

    protected abstract DataCachePCData getInternal(Object var1);

    protected abstract DataCachePCData putInternal(Object var1, DataCachePCData var2);

    protected void putAllInternal(Collection<DataCachePCData> pcs) {
        for (DataCachePCData pc : pcs) {
            this.putInternal(pc.getId(), pc);
        }
    }

    protected abstract DataCachePCData removeInternal(Object var1);

    protected abstract void removeAllInternal(Class<?> var1, boolean var2);

    protected void removeAllInternal(Collection<Object> oids) {
        for (Object oid : oids) {
            this.removeInternal(oid);
        }
    }

    protected void removeAllTypeNamesInternal(Collection<String> classNames) {
        Set<Class<?>> classes = Caches.addTypesByName(this.conf, classNames, null);
        if (classes == null) {
            return;
        }
        for (Class clazz : classes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)s_loc.get("cache-removeclass", (Object)clazz.getName()));
            }
            this.removeAllInternal(clazz, false);
        }
    }

    protected abstract void clearInternal();

    protected abstract boolean pinInternal(Object var1);

    protected abstract boolean unpinInternal(Object var1);

    @Override
    public DataCache getPartition(String name, boolean create) {
        if (Objects.equals(this._name, name)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<String> getPartitionNames() {
        return Collections.emptySet();
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public CacheStatistics getStatistics() {
        return this._stats;
    }

    public void setConfiguration(Configuration conf) {
        this.conf = (OpenJPAConfiguration)conf;
        this.log = conf.getLog("openjpa.DataCache");
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        if (this._name == null) {
            this.setName("default");
        }
    }

    protected void fireEvent(Object event, Object listener) {
        block2: {
            ExpirationListener listen = (ExpirationListener)listener;
            ExpirationEvent ev = (ExpirationEvent)event;
            try {
                listen.onExpire(ev);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block2;
                this.log.warn((Object)s_loc.get("exp-listener-ex"), (Throwable)e);
            }
        }
    }

    public Set<String> getTypes() {
        return this._includedTypes;
    }

    public Set<String> getExcludedTypes() {
        return this._excludedTypes;
    }

    public void setTypes(Set<String> types) {
        this._includedTypes = types;
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("recommend_jpa2_caching", new Object[]{"Types", DataCacheMode.ENABLE_SELECTIVE.toString()}));
        }
    }

    public void setTypes(String types) {
        HashSet<String> hashSet = this._includedTypes = StringUtil.isEmpty((String)types) ? null : new HashSet<String>(Arrays.asList(StringUtil.split((String)types, (String)";", (int)0)));
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("recommend_jpa2_caching", new Object[]{"Types", DataCacheMode.ENABLE_SELECTIVE.toString()}));
        }
    }

    public void setExcludedTypes(Set<String> types) {
        this._excludedTypes = types;
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("recommend_jpa2_caching", new Object[]{"ExcludeTypes", DataCacheMode.DISABLE_SELECTIVE.toString()}));
        }
    }

    public void setExcludedTypes(String types) {
        HashSet<String> hashSet = this._excludedTypes = StringUtil.isEmpty((String)types) ? null : new HashSet<String>(Arrays.asList(StringUtil.split((String)types, (String)";", (int)0)));
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)s_loc.get("recommend_jpa2_caching", new Object[]{"ExcludeTypes", DataCacheMode.DISABLE_SELECTIVE.toString()}));
        }
    }

    public DataCache selectCache(OpenJPAStateManager sm) {
        return this;
    }

    @Override
    public boolean getEvictOnBulkUpdate() {
        return this._evictOnBulkUpdate;
    }

    public void setEvictOnBulkUpdate(boolean b) {
        this._evictOnBulkUpdate = b;
    }
}

